/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.DynamicQuery;

class FindBindingByServiceKeyQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindBindingByServiceKeyQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindBindingByServiceKeyQuery = FindBindingByServiceKeyQuery.class$("org.apache.juddi.datastore.jdbc.FindBindingByServiceKeyQuery")) : class$org$apache$juddi$datastore$jdbc$FindBindingByServiceKeyQuery));
    static String selectSQL;
    static String tablePrefix;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindBindingByServiceKeyQuery;

    FindBindingByServiceKeyQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String serviceKey, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindBindingByServiceKeyQuery.appendWhere(sql, serviceKey, qualifiers);
        FindBindingByServiceKeyQuery.appendIn(sql, keysIn);
        FindBindingByServiceKeyQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            Vector<String> vector = keysOut;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BindingTemplate ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BindingTemplate Statement: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void appendWhere(DynamicQuery sql, String serviceKey, FindQualifiers qualifiers) {
        sql.append("WHERE B.SERVICE_KEY = ? ");
        sql.addValue(serviceKey);
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND B.BINDING_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null) {
            sql.append("B.LAST_UPDATE DESC");
        } else if (qualifiers.sortByDateAsc) {
            sql.append("B.LAST_UPDATE ASC");
        } else {
            sql.append("B.LAST_UPDATE DESC");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT B.BINDING_KEY,B.LAST_UPDATE ");
        sql.append("FROM ").append(tablePrefix).append("BINDING_TEMPLATE B ");
        selectSQL = sql.toString();
    }
}

