/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.xml;

import java.util.StringTokenizer;

public class XsSimpleDerivationSet {
    final boolean listAllowed;
    final boolean unionAllowed;
    final boolean restrictionAllowed;

    public boolean isListAllowed() {
        return this.listAllowed;
    }

    public boolean isUnionAllowed() {
        return this.unionAllowed;
    }

    public boolean isRestrictionAllowed() {
        return this.restrictionAllowed;
    }

    public static XsSimpleDerivationSet valueOf(String pValue) {
        return new XsSimpleDerivationSet(pValue);
    }

    public XsSimpleDerivationSet(String pValue) {
        if ("#all".equals(pValue)) {
            this.listAllowed = true;
            this.unionAllowed = true;
            this.restrictionAllowed = true;
        } else {
            boolean acceptList = false;
            boolean acceptUnion = false;
            boolean acceptRestriction = false;
            StringTokenizer st = new StringTokenizer(pValue, " ");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if ("list".equals(s)) {
                    acceptList = true;
                    continue;
                }
                if ("union".equals(s)) {
                    acceptUnion = true;
                    continue;
                }
                if ("restriction".equals(s)) {
                    acceptRestriction = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid derivation set value: " + pValue + "; the token " + s + " did not resolve to either of 'extension' or 'restriction'");
            }
            this.listAllowed = acceptList;
            this.unionAllowed = acceptUnion;
            this.restrictionAllowed = acceptRestriction;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.listAllowed) {
            sb.append("list");
        }
        if (this.unionAllowed) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("union");
        }
        if (this.restrictionAllowed) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("restriction");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !XsSimpleDerivationSet.class.equals(o.getClass())) {
            return false;
        }
        XsSimpleDerivationSet ds = (XsSimpleDerivationSet)o;
        return ds.listAllowed == this.listAllowed && ds.unionAllowed == this.unionAllowed && ds.restrictionAllowed == this.restrictionAllowed;
    }

    public int hashCode() {
        int result = 0;
        if (this.listAllowed) {
            ++result;
        }
        if (this.unionAllowed) {
            result += 2;
        }
        if (this.restrictionAllowed) {
            result += 4;
        }
        return result;
    }
}

