/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;

public class ParserTestCase
extends TestCase {
    public ParserTestCase(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(ParserTestCase.class);
    }

    public void testEquals() throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init();
        String template = "#if($a == $b) foo #end";
        ve.evaluate((Context)new VelocityContext(), (Writer)new StringWriter(), "foo", template);
        template = "#if($a = $b) foo #end";
        try {
            ve.evaluate((Context)new VelocityContext(), (Writer)new StringWriter(), "foo", template);
            ParserTestCase.assertTrue((boolean)false);
        }
        catch (ParseErrorException parseErrorException) {
            // empty catch block
        }
    }

    public void testEscape() throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init();
        String template = "\\${x}";
        VelocityContext vc = new VelocityContext();
        vc.put("x", "y");
        StringWriter sw = new StringWriter();
        ve.evaluate((Context)vc, (Writer)sw, "any", template);
        String result = sw.toString();
        System.out.println(result);
        ParserTestCase.assertTrue((String)result, (boolean)result.equals("${x}"));
    }

    public void testIgnore() throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init();
        VelocityContext vc = new VelocityContext();
        StringWriter sw = new StringWriter();
        ve.evaluate((Context)vc, (Writer)sw, "any", "${x.y}");
        String result = sw.toString();
        System.out.println(result);
        ParserTestCase.assertTrue((String)result, (boolean)result.equals("${x.y}"));
        sw.getBuffer().setLength(0);
        ve.evaluate((Context)vc, (Writer)sw, "any", "<text />");
        result = sw.toString();
        System.out.println("TEXT?: " + result);
        ParserTestCase.assertTrue((String)result, (boolean)result.equals("<text />"));
        sw.getBuffer().setLength(0);
        ve.evaluate((Context)vc, (Writer)sw, "any", "${x:z}");
        result = sw.toString();
        System.out.println(result);
        ParserTestCase.assertTrue((String)result, (boolean)result.equals("${x:z}"));
        sw.getBuffer().setLength(0);
        ve.evaluate((Context)vc, (Writer)sw, "any", "${x,a.b.c:z}");
        result = sw.toString();
        System.out.println(result);
        ParserTestCase.assertTrue((String)result, (boolean)result.equals("${x,a.b.c:z}"));
        sw.getBuffer().setLength(0);
        ve.evaluate((Context)vc, (Writer)sw, "any", "${jboss.partition.udpGroup:228.1.2.3}");
        result = sw.toString();
        System.out.println(result);
        ParserTestCase.assertTrue((String)result, (boolean)result.equals("${jboss.partition.udpGroup:228.1.2.3}"));
    }

    public void testMacro() throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init();
        String template = "#macro(foo) foo #end";
        ve.evaluate((Context)new VelocityContext(), (Writer)new StringWriter(), "foo", template);
        template = "#macro($x) foo #end";
        try {
            ve.evaluate((Context)new VelocityContext(), (Writer)new StringWriter(), "foo", template);
            ParserTestCase.assertTrue((boolean)false);
        }
        catch (ParseErrorException parseErrorException) {
            // empty catch block
        }
    }

    public void testArgs() throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init();
        String template = "#macro(foo) foo #end";
        ve.evaluate((Context)new VelocityContext(), (Writer)new StringWriter(), "foo", template);
        template = "#foreach(  $i     in  $woogie   ) end #end";
        ve.evaluate((Context)new VelocityContext(), (Writer)new StringWriter(), "foo", template);
        template = "#macro(   foo $a) $a #end #foo(woogie)";
        try {
            ve.evaluate((Context)new VelocityContext(), (Writer)new StringWriter(), "foo", template);
            ParserTestCase.assertTrue((boolean)false);
        }
        catch (ParseErrorException pe) {
            System.out.println("Caught pee!");
        }
    }
}

