/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.classloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempClassLoader
extends SecureClassLoader {
    private final ClassLoader delegate;

    TempClassLoader(ClassLoader delegate) {
        super(null);
        this.delegate = delegate;
    }

    @Override
    protected final Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded != null) {
            return loaded;
        }
        if (name.startsWith("javax.")) {
            return Class.forName(name, false, this.delegate);
        }
        InputStream resource = this.delegate.getResourceAsStream(name.replace('.', '/') + ".class");
        if (resource == null) {
            throw new ClassNotFoundException(name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = resource.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, i);
            }
            buffer = baos.toByteArray();
            Class<?> clazz = this.defineClass(name, buffer, 0, buffer.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    protected URL findResource(String name) {
        return this.delegate.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.delegate.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.delegate.getResourceAsStream(name);
    }
}

