/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.serialization.impl.java;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class MarshalledValueOutputStream
extends ObjectOutputStream {
    public MarshalledValueOutputStream(OutputStream os) throws IOException {
        super(os);
        EnableReplaceObjectAction.enableReplaceObject(this);
    }

    protected void annotateClass(Class cl) throws IOException {
        super.annotateClass(cl);
    }

    protected void annotateProxyClass(Class cl) throws IOException {
        super.annotateProxyClass(cl);
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        if (obj instanceof Remote && !(obj instanceof RemoteStub)) {
            Remote remote = (Remote)obj;
            try {
                obj = RemoteObject.toStub(remote);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return obj;
    }

    private static class EnableReplaceObjectAction
    implements PrivilegedAction {
        MarshalledValueOutputStream os;

        EnableReplaceObjectAction(MarshalledValueOutputStream os) {
            this.os = os;
        }

        public Object run() {
            this.os.enableReplaceObject(true);
            return null;
        }

        static void enableReplaceObject(MarshalledValueOutputStream os) {
            EnableReplaceObjectAction action = new EnableReplaceObjectAction(os);
            AccessController.doPrivileged(action);
        }
    }
}

