/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.filter;

import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.util.collection.WeakSet;

public abstract class AbstractTCLFilter
extends Filter {
    private WeakSet matchSet = new WeakSet();
    private WeakSet missSet = new WeakSet();
    private String deployURL;
    private boolean acceptOnMatch = true;

    public boolean isAcceptOnMatch() {
        return this.acceptOnMatch;
    }

    public void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    public String getDeployURL() {
        return this.deployURL;
    }

    public void setDeployURL(String deployURL) {
        this.deployURL = deployURL;
    }

    public int decide(LoggingEvent event) {
        int ok = 0;
        if (this.acceptOnMatch) {
            if (this.isMatchingTCL()) {
                ok = 1;
            }
        } else if (this.isMatchingTCL()) {
            ok = -1;
        }
        return ok;
    }

    private boolean isMatchingTCL() {
        ClassLoader cl;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (this.matchSet.contains((Object)tcl)) {
            return true;
        }
        if (this.missSet.contains((Object)tcl)) {
            return false;
        }
        for (cl = tcl; cl != null && !this.matchClassLoader(cl); cl = cl.getParent()) {
        }
        if (cl != null) {
            this.matchSet.add((Object)tcl);
        } else {
            this.missSet.add((Object)tcl);
        }
        return cl != null;
    }

    protected abstract boolean matchClassLoader(ClassLoader var1);
}

