/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration;

import java.util.Collection;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.html.HtmlAjaxCommandLink;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyDefinitionDynamic;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.gui.configuration.AbstractConfigurationComponent;
import org.rhq.core.gui.configuration.MapInConfigurationUIComponentTreeFactory;
import org.rhq.core.gui.configuration.NullComponent;
import org.rhq.core.gui.configuration.helper.PropertyRenderingUtility;
import org.rhq.core.gui.configuration.propset.ConfigurationSetComponent;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.FacesExpressionUtility;
import org.rhq.core.gui.util.PropertyIdGeneratorUtility;
import org.rhq.core.template.TemplateEngine;
import org.richfaces.component.html.HtmlModalPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyBagUIComponentTreeFactory {
    private final Log LOG = LogFactory.getLog(AbstractPropertyBagUIComponentTreeFactory.class);
    static final String DELETE_LIST_MEMBER_PROPERTY_FUNCTION = "DELETE_LIST_MEMBER_PROPERTY";
    static final String DELETE_OPEN_MAP_MEMBER_PROPERTY_FUNCTION = "DELETE_OPEN_MAP_MEMBER_PROPERTY";
    static final String PARAM_ID_SUFFIX = "-param";
    static final String PANEL_ID_SUFFIX = "-panel";
    protected static final String PROPERTY_SIMPLE_OVERRIDE_ACCESSOR_SUFFIX = "override";
    protected static final String PROPERTY_SIMPLE_VALUE_ACCESSOR_SUFFIX = "stringValue";
    protected static final String PROPERTY_LIST_VALUE_ACCESSOR_SUFFIX = "list";
    protected static final String PROPERTY_MAP_VALUE_ACCESSOR_SUFFIX = "map";
    private static final String VIEW_MAP_BUTTON_TITLE = "View Details";
    private static final String VIEW_MAP_BUTTON_LABEL = "View";
    private static final String EDIT_MAP_BUTTON_TITLE = "Edit";
    private static final String EDIT_MAP_BUTTON_LABEL = "Edit";
    private static final String DELETE_MAP_BUTTON_LABEL = "Delete";
    private static final String DELETE_MAP_BUTTON_TITLE = "Delete";
    private static final String ADD_NEW_MAP_BUTTON_LABEL = "Add New";
    private static final String ADD_NEW_MAP_BUTTON_TITLE = "Add New";
    private static final String NESTED_PROPERTIES_TABLE_STYLE_CLASS = "nested-properties-table";
    private static final String PROPERTIES_TABLE_HEADER_CELL_STYLE_CLASS = "properties-table-header-cell";
    private static final String NESTED_PROPERTIES_TABLE_HEADER_CELL_STYLE_CLASS = "nested-properties-table-header-cell";
    private static final String NESTED_PROPERTIES_TABLE_INDENT_CELL_STYLE_CLASS = "nested-properties-table-indent-cell";
    private static final String PROPERTY_ERROR_CELL_STYLE_CLASS = "property-error-cell";
    private static final String OPENMAP_PROPERTIES_TABLE_STYLE_CLASS = "openmap-properties-table";
    private static final String OPENMAP_PROPERTY_DISPLAY_NAME_CELL_STYLE_CLASS = "openmap-property-display-name-cell";
    private static final String OPENMAP_PROPERTY_VALUE_CELL_STYLE_CLASS = "openmap-property-value-cell";
    private static final String OPENMAP_PROPERTY_ACTIONS_CELL_STYLE_CLASS = "openmap-property-actions-cell";
    private static final String OPENMAP_PROPERTY_ERROR_CELL_STYLE_CLASS = "openmap-property-error-cell";
    private static final String LIST_PROPERTY_DISPLAY_NAME_CELL_STYLE_CLASS = "list-property-display-name-cell";
    private static final String LIST_PROPERTY_VALUE_CELL_STYLE_CLASS = "list-property-value-cell";
    private static final String LIST_PROPERTY_DESCRIPTION_CELL_STYLE_CLASS = "list-property-description-cell";
    private static final String LIST_PROPERTY_ENABLED_CELL_STYLE_CLASS = "list-property-enabled-cell";
    private static final String LIST_PROPERTY_CHILDREN_CELL_STYLE_CLASS = "list-property-children-cell";
    private static final String PROPERTY_MAP_SUMMARY_TABLE_STYLE_CLASS = "property-map-summary-table";
    private static final String PROPERTY_MAP_SUMMARY_DATA_HEADER_CELL_STYLE_CLASS = "property-map-summary-data-header-cell";
    private static final String PROPERTY_MAP_SUMMARY_HEADER_TEXT_STYLE_CLASS = "property-map-summary-header-text";
    private static final String PROPERTY_MAP_SUMMARY_BUTTONS_CELL_STYLE_CLASS = "property-map-summary-buttons-cell";
    private static final String PROPERTY_MAP_SUMMARY_DATA_CELL_STYLE_CLASS = "property-map-summary-data-cell";
    private static final String PROPERTY_MAP_SUMMARY_DATA_TEXT_STYLE_CLASS = "property-map-summary-data-text";
    private static final String PROPERTY_MAP_SUMMARY_BUTTON_FOOTER_STYLE_CLASS = "property-buttonfooterrow";
    private static final String BUTTONS_TABLE_STYLE_CLASS = "buttons-table";
    private static final String VALUES_DIFFER_TEXT_STYLE_CLASS = "values-differ-text";
    private AbstractConfigurationComponent config;
    private Collection<PropertyDefinition> propertyDefinitions;
    private AbstractPropertyMap propertyMap;
    private boolean topLevel;
    private String valueExpressionFormat;
    private String overrideExpressionFormat;
    private boolean isGroup;
    private HtmlModalPanel memberValuesModalPanel;

    public AbstractPropertyBagUIComponentTreeFactory(AbstractConfigurationComponent config, Collection<PropertyDefinition> propertyDefinitions, AbstractPropertyMap propertyMap, boolean topLevel, String valueExpressionFormat) {
        this.config = config;
        this.propertyDefinitions = propertyDefinitions;
        this.propertyMap = propertyMap;
        this.topLevel = topLevel;
        this.valueExpressionFormat = valueExpressionFormat;
        this.overrideExpressionFormat = this.getOverrideExpressionFormat(valueExpressionFormat);
        this.isGroup = this.config instanceof ConfigurationSetComponent;
        if (this.isGroup) {
            ConfigurationSetComponent configurationSetComponent = (ConfigurationSetComponent)this.config;
            this.memberValuesModalPanel = configurationSetComponent.getPropSetModalPanel();
        }
    }

    private String getOverrideExpressionFormat(String valueExpression) {
        int index = valueExpression.lastIndexOf(".");
        return valueExpression.substring(0, index) + "." + PROPERTY_SIMPLE_OVERRIDE_ACCESSOR_SUFFIX + "}";
    }

    protected Integer getListIndex() {
        return null;
    }

    public UIComponent createUIComponentTree(String rowStyleClass) {
        HtmlPanelGroup rootPanel = FacesComponentUtility.createBlockPanel(this.config, FacesComponentUtility.NO_STYLE_CLASS);
        if (!this.propertyDefinitions.isEmpty() || this.propertyMap instanceof PropertyMap) {
            if (!this.propertyDefinitions.isEmpty()) {
                boolean alternateRowStyles;
                String tableStyleClass = this.topLevel ? "properties-table" : NESTED_PROPERTIES_TABLE_STYLE_CLASS;
                FacesComponentUtility.addVerbatimText((UIComponent)rootPanel, "\n\n<table class='" + tableStyleClass + "'>");
                int rowCount = 0;
                boolean bl = alternateRowStyles = rowStyleClass == null;
                if (this.containsSimpleProperties()) {
                    this.addSimplePropertiesTableHeaders((UIComponent)rootPanel);
                }
                for (PropertyDefinition propertyDefinition : this.propertyDefinitions) {
                    rowStyleClass = this.getRowStyleClass(rowStyleClass, rowCount, alternateRowStyles);
                    this.addProperty((UIComponent)rootPanel, propertyDefinition, rowStyleClass);
                    ++rowCount;
                }
            } else {
                PropertyDefinitionMap propertyDefinitionMap = this.config.getConfigurationDefinition().getPropertyDefinitionMap(((PropertyMap)this.propertyMap).getName());
                FacesComponentUtility.addVerbatimText((UIComponent)rootPanel, "\n\n<table class='openmap-properties-table'>");
                this.addOpenMapMemberPropertiesTableHeaders((UIComponent)rootPanel, propertyDefinitionMap);
                for (Property property : this.propertyMap.getMap().values()) {
                    if (!(property instanceof PropertySimple)) {
                        throw new IllegalStateException("Open map " + this.propertyMap + " contains non-simple property: " + property);
                    }
                    PropertySimple propertySimple = (PropertySimple)property;
                    this.addOpenMapMemberProperty(rootPanel, propertyDefinitionMap, propertySimple, rowStyleClass);
                }
                this.addNewOpenMapMemberPropertyRow((UIComponent)rootPanel, propertyDefinitionMap);
            }
            FacesComponentUtility.addVerbatimText((UIComponent)rootPanel, "</table>");
        }
        return rootPanel;
    }

    private String getRowStyleClass(String rowStyleClass, int rowCount, boolean alternateRowStyles) {
        if (alternateRowStyles) {
            rowStyleClass = rowCount % 2 == 0 ? "OddRow" : "EvenRow";
        }
        return rowStyleClass;
    }

    private void addSimplePropertiesTableHeaders(UIComponent parent) {
        String headerCellStyleClass = this.topLevel ? PROPERTIES_TABLE_HEADER_CELL_STYLE_CLASS : NESTED_PROPERTIES_TABLE_HEADER_CELL_STYLE_CLASS;
        FacesComponentUtility.addVerbatimText(parent, "\n\n<tr>");
        FacesComponentUtility.addVerbatimText(parent, "<th class='" + headerCellStyleClass + "'>");
        FacesComponentUtility.addOutputText(parent, this.config, "Name", FacesComponentUtility.NO_STYLE_CLASS);
        FacesComponentUtility.addVerbatimText(parent, "</th>");
        if (this.config.isGroup()) {
            FacesComponentUtility.addVerbatimText(parent, "<th class='" + headerCellStyleClass + "'>");
            FacesComponentUtility.addOutputText(parent, this.config, "Override", FacesComponentUtility.NO_STYLE_CLASS);
            FacesComponentUtility.addVerbatimText(parent, "</th>");
        }
        FacesComponentUtility.addVerbatimText(parent, "<th class='" + headerCellStyleClass + "'>");
        FacesComponentUtility.addOutputText(parent, this.config, "Unset", FacesComponentUtility.NO_STYLE_CLASS);
        FacesComponentUtility.addVerbatimText(parent, "</th>");
        FacesComponentUtility.addVerbatimText(parent, "<th class='" + headerCellStyleClass + "'>");
        FacesComponentUtility.addOutputText(parent, this.config, "Value", FacesComponentUtility.NO_STYLE_CLASS);
        FacesComponentUtility.addVerbatimText(parent, "</th>");
        FacesComponentUtility.addVerbatimText(parent, "<th class='" + headerCellStyleClass + "'>");
        FacesComponentUtility.addOutputText(parent, this.config, "Description", FacesComponentUtility.NO_STYLE_CLASS);
        FacesComponentUtility.addVerbatimText(parent, "</th>");
        FacesComponentUtility.addVerbatimText(parent, "</tr>");
    }

    private boolean containsSimpleProperties() {
        boolean containsSimples = false;
        for (PropertyDefinition propertyDefinition : this.propertyDefinitions) {
            if (!(propertyDefinition instanceof PropertyDefinitionSimple)) continue;
            containsSimples = true;
            break;
        }
        return containsSimples;
    }

    private void addOpenMapMemberPropertiesTableHeaders(UIComponent parent, PropertyDefinitionMap propertyDefinitionMap) {
        String headerCellStyleClass = this.topLevel ? PROPERTIES_TABLE_HEADER_CELL_STYLE_CLASS : NESTED_PROPERTIES_TABLE_HEADER_CELL_STYLE_CLASS;
        FacesComponentUtility.addVerbatimText(parent, "\n\n<tr>");
        FacesComponentUtility.addVerbatimText(parent, "<th class='" + headerCellStyleClass + "'>");
        FacesComponentUtility.addOutputText(parent, this.config, "Name", FacesComponentUtility.NO_STYLE_CLASS);
        FacesComponentUtility.addVerbatimText(parent, "</th>");
        FacesComponentUtility.addVerbatimText(parent, "<th class='" + headerCellStyleClass + "'>");
        FacesComponentUtility.addOutputText(parent, this.config, "Value", FacesComponentUtility.NO_STYLE_CLASS);
        FacesComponentUtility.addVerbatimText(parent, "</th>");
        if (!this.isReadOnly((PropertyDefinition)propertyDefinitionMap)) {
            FacesComponentUtility.addVerbatimText(parent, "<th class='" + headerCellStyleClass + "'>");
            FacesComponentUtility.addOutputText(parent, this.config, "Actions", FacesComponentUtility.NO_STYLE_CLASS);
            FacesComponentUtility.addVerbatimText(parent, "</th>");
        }
        FacesComponentUtility.addVerbatimText(parent, "</tr>");
    }

    protected AbstractConfigurationComponent getConfigurationComponent() {
        return this.config;
    }

    private void addProperty(UIComponent parent, PropertyDefinition propertyDefinition, String rowStyleClass) {
        if (propertyDefinition instanceof PropertyDefinitionSimple) {
            this.addSimpleProperty(parent, (PropertyDefinitionSimple)propertyDefinition, rowStyleClass, this.config.getTemplateEngine());
        } else if (propertyDefinition instanceof PropertyDefinitionList) {
            this.addListProperty(parent, (PropertyDefinitionList)propertyDefinition, rowStyleClass);
        } else if (propertyDefinition instanceof PropertyDefinitionMap) {
            this.addMapProperty(parent, (PropertyDefinitionMap)propertyDefinition, rowStyleClass);
        } else if (propertyDefinition instanceof PropertyDefinitionDynamic) {
            this.addDynamicProperty(parent, (PropertyDefinitionDynamic)propertyDefinition, rowStyleClass);
        } else {
            throw new IllegalStateException("Unsupported subclass of " + PropertyDefinition.class.getName() + ".");
        }
    }

    private void addDynamicProperty(UIComponent parent, PropertyDefinitionDynamic propertyDefinitionDynamic, String rowStyleClass) {
        this.addDebug(parent, true, ".addDynamicProperty()");
        FacesComponentUtility.addVerbatimText(parent, "\n\n<tr class='" + rowStyleClass + "'>");
        PropertySimple propertySimple = this.propertyMap.getSimple(propertyDefinitionDynamic.getName());
        ValueExpression propertyValueExpression = AbstractPropertyBagUIComponentTreeFactory.createPropertyValueExpression(propertySimple.getName(), this.valueExpressionFormat);
        UIInput input = null;
        if (!this.isGroup || propertySimple.getOverride() != null && propertySimple.getOverride().booleanValue()) {
            input = PropertyRenderingUtility.createInputForDynamicProperty(propertyDefinitionDynamic, propertySimple, propertyValueExpression, this.getListIndex(), this.isGroup, this.config.isReadOnly(), this.config.isFullyEditable(), this.config.isPrevalidate());
        }
        FacesComponentUtility.addVerbatimText(parent, "<td class='property-display-name-cell'>");
        PropertyRenderingUtility.addPropertyDisplayName(parent, (PropertyDefinition)propertyDefinitionDynamic, (Property)propertySimple, this.config.isReadOnly());
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "<td class='property-enabled-cell'>");
        if (!propertyDefinitionDynamic.isRequired()) {
            PropertyRenderingUtility.addUnsetControl(parent, propertyDefinitionDynamic.isRequired(), propertyDefinitionDynamic.isReadOnly(), propertySimple, this.config.getListIndex(), input, this.isGroup, this.config.isReadOnly(), this.config.isFullyEditable());
        }
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "<td class='property-value-cell'>");
        this.addPropertySimpleValue(parent, input, propertyValueExpression);
        FacesComponentUtility.addVerbatimText(parent, "<br/>");
        if (input != null) {
            PropertyRenderingUtility.addMessageComponentForInput(parent, input);
        }
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "<td class='property-description-cell'>");
        PropertyRenderingUtility.addPropertyDescription(parent, (PropertyDefinition)propertyDefinitionDynamic);
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "</tr>");
        this.addDebug(parent, false, ".addSimpleProperty()");
    }

    private void addSimpleProperty(UIComponent parent, PropertyDefinitionSimple propertyDefinitionSimple, String rowStyleClass, TemplateEngine templateEngine) {
        this.addDebug(parent, true, ".addSimpleProperty()");
        FacesComponentUtility.addVerbatimText(parent, "\n\n<tr class='" + rowStyleClass + "'>");
        PropertySimple propertySimple = this.propertyMap.getSimple(propertyDefinitionSimple.getName());
        ValueExpression propertyValueExpression = AbstractPropertyBagUIComponentTreeFactory.createPropertyValueExpression(propertySimple.getName(), this.valueExpressionFormat);
        UIInput input = null;
        if (!this.isGroup || propertySimple.getOverride() != null && propertySimple.getOverride().booleanValue()) {
            input = PropertyRenderingUtility.createInputForSimpleProperty(propertyDefinitionSimple, propertySimple, propertyValueExpression, this.getListIndex(), this.isGroup, this.config.isReadOnly(), this.config.isFullyEditable(), this.config.isPrevalidate(), templateEngine);
        }
        FacesComponentUtility.addVerbatimText(parent, "<td class='property-display-name-cell'>");
        PropertyRenderingUtility.addPropertyDisplayName(parent, (PropertyDefinition)propertyDefinitionSimple, (Property)propertySimple, this.config.isReadOnly());
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        if (this.config.isGroup()) {
            FacesComponentUtility.addVerbatimText(parent, "<td class='property-enabled-cell'>");
            this.addPropertyOverrideControl(parent, propertyDefinitionSimple, input);
            FacesComponentUtility.addVerbatimText(parent, "</td>");
        }
        FacesComponentUtility.addVerbatimText(parent, "<td class='property-enabled-cell'>");
        if (!propertyDefinitionSimple.isRequired()) {
            PropertyRenderingUtility.addUnsetControl(parent, propertyDefinitionSimple.isRequired(), propertyDefinitionSimple.isReadOnly(), propertySimple, this.config.getListIndex(), input, this.isGroup, this.config.isReadOnly(), this.config.isFullyEditable());
        }
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "<td class='property-value-cell'>");
        this.addPropertySimpleValue(parent, input, propertyValueExpression);
        FacesComponentUtility.addVerbatimText(parent, "<br/>");
        if (input != null) {
            PropertyRenderingUtility.addMessageComponentForInput(parent, input);
        }
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "<td class='property-description-cell'>");
        PropertyRenderingUtility.addPropertyDescription(parent, (PropertyDefinition)propertyDefinitionSimple);
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "</tr>");
        this.addDebug(parent, false, ".addSimpleProperty()");
    }

    private void addPropertySimpleValue(UIComponent parent, UIInput input, ValueExpression propertyValueExpression) {
        if (!this.isGroup) {
            parent.getChildren().add(input);
            return;
        }
        HtmlPanelGrid panelGrid = FacesComponentUtility.addPanelGrid(parent, null, 2, BUTTONS_TABLE_STYLE_CLASS);
        panelGrid.setColumnClasses("group-property-value-cell, group-property-members-icon-cell");
        if (input != null) {
            panelGrid.getChildren().add(input);
        } else {
            FacesComponentUtility.addOutputText((UIComponent)panelGrid, null, "Member Values Differ", VALUES_DIFFER_TEXT_STYLE_CLASS);
        }
        HtmlAjaxCommandLink ajaxCommandLink = FacesComponentUtility.createComponent(HtmlAjaxCommandLink.class);
        panelGrid.getChildren().add(ajaxCommandLink);
        ajaxCommandLink.setOncomplete("Richfaces.showModalPanel('" + this.memberValuesModalPanel.getClientId(FacesContext.getCurrentInstance()) + "');");
        String verb = this.config.isReadOnly() ? VIEW_MAP_BUTTON_LABEL : "Edit";
        String tooltip = verb + " Member Values";
        ajaxCommandLink.setTitle(tooltip);
        FacesComponentUtility.addParameter((UIComponent)ajaxCommandLink, null, "propertyExpressionString", propertyValueExpression.getExpressionString());
        FacesComponentUtility.addParameter((UIComponent)ajaxCommandLink, null, "refresh", "rhq_propSet");
        FacesComponentUtility.addGraphicImage((UIComponent)ajaxCommandLink, null, "/images/icn_member_configs.png", null);
    }

    private void addOpenMapMemberProperty(HtmlPanelGroup parent, PropertyDefinitionMap propertyDefinitionMap, PropertySimple propertySimple, String rowStyleClass) {
        this.addDebug((UIComponent)parent, true, ".addOpenMapMemberProperty()");
        String mapName = ((PropertyMap)this.propertyMap).getName();
        String memberName = propertySimple.getName();
        NullComponent wrapper = new NullComponent();
        parent.getChildren().add(wrapper);
        String wrapperId = PropertyIdGeneratorUtility.getIdentifier((Property)propertySimple, this.getListIndex(), PANEL_ID_SUFFIX);
        wrapper.setId(wrapperId);
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "\n\n<tr class='" + rowStyleClass + "'>");
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "<td class='openmap-property-display-name-cell'>");
        FacesComponentUtility.addOutputText((UIComponent)wrapper, this.config, propertySimple.getName(), "property-display-name-text");
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "</td>");
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "<td class='openmap-property-value-cell'>");
        String expressionString = String.format(this.valueExpressionFormat, propertySimple.getName());
        ValueExpression valueExpression = FacesExpressionUtility.createValueExpression(expressionString, String.class);
        UIInput input = null;
        if (!this.isGroup || propertySimple.getOverride() != null && propertySimple.getOverride().booleanValue()) {
            input = PropertyRenderingUtility.createInputForSimpleProperty(propertySimple, valueExpression, this.config.isReadOnly());
        }
        this.addPropertySimpleValue((UIComponent)wrapper, input, valueExpression);
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "</td>");
        if (!this.isReadOnly((PropertyDefinition)propertyDefinitionMap)) {
            FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "<td class='openmap-property-actions-cell'>");
            HtmlCommandLink deleteLink = FacesComponentUtility.createComponent(HtmlCommandLink.class);
            wrapper.getChildren().add(deleteLink);
            deleteLink.setTitle("Delete");
            deleteLink.setImmediate(true);
            FacesComponentUtility.addParameter((UIComponent)deleteLink, this.config, "function", DELETE_OPEN_MAP_MEMBER_PROPERTY_FUNCTION);
            FacesComponentUtility.addParameter((UIComponent)deleteLink, this.config, "mapName", mapName);
            FacesComponentUtility.addParameter((UIComponent)deleteLink, this.config, "memberName", memberName);
            FacesComponentUtility.addButton((UIComponent)deleteLink, "Delete", "buttonsmall");
            FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "</td>");
        }
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "</tr>");
        this.addDebug((UIComponent)wrapper, false, ".addOpenMapMemberProperty()");
    }

    private void addListProperty(UIComponent parent, PropertyDefinitionList listPropertyDefinition, String rowStyleClass) {
        this.addDebug(parent, true, ".addListProperty()");
        if (!this.topLevel) {
            throw new IllegalStateException("Lists are only supported at the top level of a Configuration.");
        }
        PropertyList listProperty = this.propertyMap.getList(listPropertyDefinition.getName());
        FacesComponentUtility.addVerbatimText(parent, "\n\n<tr class='" + rowStyleClass + "'>");
        FacesComponentUtility.addVerbatimText(parent, "<td class='list-property-display-name-cell'>");
        PropertyRenderingUtility.addPropertyDisplayName(parent, (PropertyDefinition)listPropertyDefinition, (Property)listProperty, this.config.isReadOnly());
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "<td class='list-property-enabled-cell' />");
        FacesComponentUtility.addVerbatimText(parent, "<td class='list-property-value-cell' />");
        FacesComponentUtility.addVerbatimText(parent, "<td class='list-property-description-cell'>");
        PropertyRenderingUtility.addPropertyDescription(parent, (PropertyDefinition)listPropertyDefinition);
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "</tr>");
        PropertyDefinition listMemberPropertyDefinition = listPropertyDefinition.getMemberDefinition();
        if (listMemberPropertyDefinition instanceof PropertyDefinitionMap) {
            if (!this.isGroup) {
                this.addListMemberMapProperties(parent, listProperty, (PropertyDefinitionMap)listMemberPropertyDefinition, rowStyleClass);
            } else {
                this.addErrorRow(parent, "Viewing/editing of lists of properties is not yet supported for group Configurations. To view/edit this property for group members, please go to the Configure>Current tab for each member separately.", rowStyleClass);
            }
        } else {
            this.addErrorRow(parent, "Viewing/editing of lists of " + listMemberPropertyDefinition.getClass().getSimpleName() + " properties is not yet supported. Here's the list's toString() value for now: " + (listProperty != null ? listProperty.getList() : null), rowStyleClass);
        }
        this.addDebug(parent, false, ".addListProperty()");
    }

    private void addListMemberMapProperties(UIComponent parent, PropertyList listProperty, PropertyDefinitionMap listMemberPropertyDefinition, String rowStyleClass) {
        this.addDebug(parent, true, ".addListMemberMapProperties()");
        PropertyDefinitionMap listMemberMapPropertyDefinition = listMemberPropertyDefinition;
        this.validateMapDefinition(listMemberMapPropertyDefinition);
        FacesComponentUtility.addVerbatimText(parent, "\n\n<tr class='" + rowStyleClass + "'>\n");
        FacesComponentUtility.addVerbatimText(parent, "<td colspan='4' class='list-property-children-cell'>");
        List mapSummaryPropertyDefinitions = listMemberMapPropertyDefinition.getSummaryPropertyDefinitions();
        FacesComponentUtility.addVerbatimText(parent, "\n<!-- start list of maps -->\n");
        FacesComponentUtility.addVerbatimText(parent, "<table class='property-map-summary-table'>\n");
        FacesComponentUtility.addVerbatimText(parent, "<tbody>\n");
        FacesComponentUtility.addVerbatimText(parent, "<tr>\n");
        for (PropertyDefinition summaryPropertyDefinition : listMemberMapPropertyDefinition.getSummaryPropertyDefinitions()) {
            PropertyDefinitionSimple mapMemberSimplePropertyDefinition = (PropertyDefinitionSimple)listMemberMapPropertyDefinition.get(summaryPropertyDefinition.getName());
            FacesComponentUtility.addVerbatimText(parent, "<th class='property-map-summary-data-header-cell'>");
            FacesComponentUtility.addOutputText(parent, this.config, mapMemberSimplePropertyDefinition.getDisplayName(), PROPERTY_MAP_SUMMARY_HEADER_TEXT_STYLE_CLASS);
            FacesComponentUtility.addVerbatimText(parent, "</th>\n");
        }
        FacesComponentUtility.addVerbatimText(parent, "<th class='property-map-summary-data-header-cell'>");
        FacesComponentUtility.addOutputText(parent, this.config, "Actions", PROPERTY_MAP_SUMMARY_HEADER_TEXT_STYLE_CLASS);
        FacesComponentUtility.addVerbatimText(parent, "</th>\n");
        FacesComponentUtility.addVerbatimText(parent, "</tr>\n");
        String viewEditButtonLabel = this.config.isReadOnly() ? VIEW_MAP_BUTTON_LABEL : "Edit";
        String viewEditButtonTitle = this.config.isReadOnly() ? VIEW_MAP_BUTTON_TITLE : "Edit";
        for (int index = 0; index < listProperty.getList().size(); ++index) {
            this.addListMemberMapProperty(parent, listProperty, listMemberMapPropertyDefinition, viewEditButtonLabel, viewEditButtonTitle, index);
        }
        if (!this.isReadOnly((PropertyDefinition)listMemberMapPropertyDefinition.getParentPropertyListDefinition())) {
            FacesComponentUtility.addVerbatimText(parent, "<tr>\n");
            FacesComponentUtility.addVerbatimText(parent, "<td colspan='" + (mapSummaryPropertyDefinitions.size() + 1) + "' class='" + PROPERTY_MAP_SUMMARY_BUTTON_FOOTER_STYLE_CLASS + "'>");
            HtmlCommandLink addNewLink = FacesComponentUtility.addCommandLink(parent, this.config);
            addNewLink.setTitle("Add New");
            MethodExpression actionExpression = FacesExpressionUtility.createMethodExpression("#{ConfigHelperUIBean.addNewMap}", String.class, new Class[0]);
            addNewLink.setActionExpression(actionExpression);
            FacesComponentUtility.addParameter((UIComponent)addNewLink, this.config, "listName", listProperty.getName());
            FacesComponentUtility.addParameter((UIComponent)addNewLink, this.config, "listIndex", String.valueOf(listProperty.getList().size()));
            FacesComponentUtility.addButton((UIComponent)addNewLink, "Add New", "buttonsmall");
            FacesComponentUtility.addVerbatimText(parent, "</td></tr>\n");
        }
        FacesComponentUtility.addVerbatimText(parent, "</tbody></table>\n\n");
        FacesComponentUtility.addVerbatimText(parent, "<!-- end List of Maps -->\n\n");
        FacesComponentUtility.addVerbatimText(parent, "</td></tr>");
        this.addDebug(parent, false, ".addListMemberMapProperties()");
    }

    private void addListMemberMapProperty(UIComponent parent, PropertyList listProperty, PropertyDefinitionMap listMemberMapPropertyDefinition, String viewEditButtonLabel, String viewEditButtonTitle, int index) {
        this.addDebug(parent, true, ".addListMemberMapProperty()");
        Property listMemberProperty = (Property)listProperty.getList().get(index);
        String listName = listProperty.getName();
        if (!(listMemberProperty instanceof PropertyMap)) {
            throw new IllegalStateException("Property '" + listName + "' is defined as a list of maps but contains one or more non-map members.");
        }
        PropertyMap listMemberPropertyMap = (PropertyMap)listMemberProperty;
        NullComponent wrapper = new NullComponent();
        parent.getChildren().add(wrapper);
        String wrapperId = PropertyIdGeneratorUtility.getIdentifier(listMemberProperty, index, PANEL_ID_SUFFIX);
        wrapper.setId(wrapperId);
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "<tr>\n");
        this.addPropertyMapSummaryDataCells((UIComponent)wrapper, listMemberMapPropertyDefinition, listMemberPropertyMap);
        int numberOfButtons = 1;
        if (!this.config.isReadOnly()) {
            ++numberOfButtons;
        }
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "<td class='property-map-summary-buttons-cell'>");
        HtmlPanelGrid buttonsPanelGrid = FacesComponentUtility.addPanelGrid((UIComponent)wrapper, this.config, numberOfButtons, BUTTONS_TABLE_STYLE_CLASS);
        HtmlCommandLink viewEditLink = FacesComponentUtility.addCommandLink((UIComponent)buttonsPanelGrid, this.config);
        viewEditLink.setTitle(viewEditButtonTitle);
        MethodExpression actionExpression = FacesExpressionUtility.createMethodExpression("#{ConfigHelperUIBean.accessMap}", String.class, new Class[0]);
        viewEditLink.setActionExpression(actionExpression);
        FacesComponentUtility.addParameter((UIComponent)viewEditLink, this.config, "listName", listName);
        String listIndex = String.valueOf(index);
        FacesComponentUtility.addParameter((UIComponent)viewEditLink, this.config, "listIndex", listIndex);
        int configId = this.config.getConfiguration().getId();
        FacesComponentUtility.addParameter((UIComponent)viewEditLink, this.config, "configId", String.valueOf(configId));
        FacesComponentUtility.addButton((UIComponent)viewEditLink, viewEditButtonLabel, "buttonsmall");
        if (!this.isReadOnly((PropertyDefinition)listMemberMapPropertyDefinition.getParentPropertyListDefinition())) {
            HtmlCommandLink deleteLink = FacesComponentUtility.addCommandLink((UIComponent)buttonsPanelGrid, this.config);
            deleteLink.setTitle("Delete");
            FacesComponentUtility.addParameter((UIComponent)deleteLink, this.config, "function", DELETE_LIST_MEMBER_PROPERTY_FUNCTION);
            FacesComponentUtility.addParameter((UIComponent)deleteLink, this.config, "listName", listName);
            UIParameter listIndexParam = FacesComponentUtility.addParameter((UIComponent)deleteLink, this.config, "listIndex", listIndex);
            String paramId = PropertyIdGeneratorUtility.getIdentifier(listMemberProperty, index, PARAM_ID_SUFFIX);
            listIndexParam.setId(paramId);
            FacesComponentUtility.addButton((UIComponent)deleteLink, "Delete", "buttonsmall");
        }
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "</td>\n");
        FacesComponentUtility.addVerbatimText((UIComponent)wrapper, "</tr>\n");
        this.addDebug(parent, false, ".addListMemberMapProperty()");
    }

    private void addPropertyMapSummaryDataCells(UIComponent parent, PropertyDefinitionMap listMemberMapPropertyDefinition, PropertyMap listMemberMapProperty) {
        for (PropertyDefinition summaryPropertyDefinition : listMemberMapPropertyDefinition.getSummaryPropertyDefinitions()) {
            Property mapMemberProperty = listMemberMapProperty.get(summaryPropertyDefinition.getName());
            if (!(mapMemberProperty instanceof PropertySimple)) {
                throw new IllegalStateException("Property '" + mapMemberProperty.getName() + "' is defined as a map of simples but contains one or more non-simple members.");
            }
            PropertySimple mapMemberSimpleProperty = (PropertySimple)mapMemberProperty;
            FacesComponentUtility.addVerbatimText(parent, "<td class='property-map-summary-data-cell'>");
            if (mapMemberSimpleProperty.getStringValue() == null) {
                FacesComponentUtility.addOutputText(parent, this.config, "not set", "required-marker-text");
            } else {
                FacesComponentUtility.addOutputText(parent, this.config, mapMemberSimpleProperty.getStringValue(), PROPERTY_MAP_SUMMARY_DATA_TEXT_STYLE_CLASS);
            }
            FacesComponentUtility.addVerbatimText(parent, "</td>\n");
        }
    }

    private void validateMapDefinition(PropertyDefinitionMap propertyDefinitionMap) {
        for (PropertyDefinition mapMemberPropertyDefinition : propertyDefinitionMap.getPropertyDefinitions().values()) {
            if (mapMemberPropertyDefinition instanceof PropertyDefinitionSimple) continue;
            throw new IllegalStateException("Only maps of simple properties are supported.");
        }
    }

    private void addMapProperty(UIComponent parent, PropertyDefinitionMap propertyDefinitionMap, String rowStyleClass) {
        if (!this.topLevel) {
            throw new IllegalStateException("Maps are only supported at the top level of a Configuration or within a top-level List.");
        }
        this.validateMapDefinition(propertyDefinitionMap);
        FacesComponentUtility.addVerbatimText(parent, "\n\n<tr class='" + rowStyleClass + "'>");
        FacesComponentUtility.addVerbatimText(parent, "<td class='list-property-display-name-cell'>");
        PropertyRenderingUtility.addPropertyDisplayName(parent, (PropertyDefinition)propertyDefinitionMap, this.propertyMap.get(propertyDefinitionMap.getName()), this.config.isReadOnly());
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "<td class='list-property-enabled-cell' />");
        FacesComponentUtility.addVerbatimText(parent, "<td class='list-property-value-cell' />");
        FacesComponentUtility.addVerbatimText(parent, "<td class='list-property-description-cell'>");
        PropertyRenderingUtility.addPropertyDescription(parent, (PropertyDefinition)propertyDefinitionMap);
        FacesComponentUtility.addVerbatimText(parent, "</td>");
        FacesComponentUtility.addVerbatimText(parent, "</tr>");
        this.addMapMemberProperties(parent, propertyDefinitionMap.getName(), rowStyleClass);
    }

    private void addMapMemberProperties(UIComponent parent, String mapName, String rowStyleClass) {
        FacesComponentUtility.addVerbatimText(parent, "\n\n<tr class='" + rowStyleClass + "'>\n");
        FacesComponentUtility.addVerbatimText(parent, "<td colspan='4' class='list-property-children-cell'>");
        HtmlPanelGrid spacerPanelGrid = FacesComponentUtility.addPanelGrid(parent, this.config, 2, FacesComponentUtility.NO_STYLE_CLASS);
        spacerPanelGrid.setWidth("100%");
        spacerPanelGrid.setColumnClasses("nested-properties-table-indent-cell," + FacesComponentUtility.NO_STYLE_CLASS);
        FacesComponentUtility.addBlockPanel((UIComponent)spacerPanelGrid, this.config, FacesComponentUtility.NO_STYLE_CLASS);
        MapInConfigurationUIComponentTreeFactory propertyListUIComponentTreeFactory = new MapInConfigurationUIComponentTreeFactory(this.config, mapName);
        spacerPanelGrid.getChildren().add(propertyListUIComponentTreeFactory.createUIComponentTree("EvenRow"));
        parent.getChildren().add(spacerPanelGrid);
        FacesComponentUtility.addVerbatimText(parent, "</td></tr>\n");
    }

    private void addNewOpenMapMemberPropertyRow(UIComponent parent, PropertyDefinitionMap propertyDefinitionMap) {
        if (!this.isReadOnly((PropertyDefinition)propertyDefinitionMap)) {
            FacesComponentUtility.addVerbatimText(parent, "\n\n<tr><td colspan='3' class='property-buttonfooterrow'>");
            HtmlCommandLink addNewLink = FacesComponentUtility.addCommandLink(parent, this.config);
            addNewLink.setTitle("Add New");
            MethodExpression actionExpression = FacesExpressionUtility.createMethodExpression("#{ConfigHelperUIBean.addNewOpenMapMemberProperty}", String.class, new Class[0]);
            addNewLink.setActionExpression(actionExpression);
            FacesComponentUtility.addParameter((UIComponent)addNewLink, this.config, "mapName", propertyDefinitionMap.getName());
            FacesComponentUtility.addButton((UIComponent)addNewLink, "Add New", "buttonsmall");
            FacesComponentUtility.addVerbatimText(parent, "</td></tr>");
        }
    }

    private void addErrorRow(UIComponent parent, String errorMsg, String rowStyleClass) {
        this.addDebug(parent, true, ".addErrorRow()");
        FacesComponentUtility.addVerbatimText(parent, "\n\n<tr class='" + rowStyleClass + "'><td colspan='4' class='" + PROPERTY_ERROR_CELL_STYLE_CLASS + "'><h4>" + errorMsg + "</h4></td></tr>");
        this.addDebug(parent, false, ".addErrorRow()");
    }

    private HtmlSelectBooleanCheckbox createInputOverrideForSimpleProperty(PropertyDefinitionSimple propertyDefinitionSimple) {
        HtmlSelectBooleanCheckbox input = FacesComponentUtility.createComponent(HtmlSelectBooleanCheckbox.class, this.config);
        Property property = this.propertyMap.get(propertyDefinitionSimple.getName());
        if (property != null) {
            String propertyId = PropertyIdGeneratorUtility.getIdentifier(property, this.getListIndex(), PROPERTY_SIMPLE_OVERRIDE_ACCESSOR_SUFFIX);
            input.setId(propertyId);
            Boolean shouldOverride = ((PropertySimple)property).getOverride();
            FacesComponentUtility.setOverride((UIInput)input, shouldOverride != null && shouldOverride != false);
        }
        this.setInputOverrideExpression(input, propertyDefinitionSimple.getName());
        return input;
    }

    private void addPropertyOverrideControl(UIComponent parent, PropertyDefinitionSimple propertyDefinitionSimple, UIInput valueInput) {
        HtmlSelectBooleanCheckbox overrideCheckbox = this.createInputOverrideForSimpleProperty(propertyDefinitionSimple);
        parent.getChildren().add(overrideCheckbox);
        overrideCheckbox.setValue((Object)this.isOverride((PropertyDefinition)propertyDefinitionSimple));
        if (this.isReadOnly((PropertyDefinition)propertyDefinitionSimple)) {
            FacesComponentUtility.setDisabled((UIComponent)overrideCheckbox, true);
        }
        StringBuilder onclick = new StringBuilder();
        for (String valueInputHtmlDomReference : PropertyRenderingUtility.getHtmlDomReferences((UIComponent)valueInput)) {
            onclick.append("setInputOverride(").append(valueInputHtmlDomReference).append(", this.checked);");
        }
        overrideCheckbox.setOnclick(onclick.toString());
    }

    private void setInputOverrideExpression(HtmlSelectBooleanCheckbox input, String propertyName) {
        String expression = String.format(this.overrideExpressionFormat, propertyName);
        ValueExpression valueExpression = FacesExpressionUtility.createValueExpression(expression, Boolean.class);
        input.setValueExpression("value", valueExpression);
    }

    private Boolean isOverride(PropertyDefinition propertyDefinition) {
        if (!(propertyDefinition instanceof PropertyDefinitionSimple)) {
            return false;
        }
        Property property = this.propertyMap.get(propertyDefinition.getName());
        if (property == null) {
            return false;
        }
        Boolean override = ((PropertySimple)property).getOverride();
        return override != null && override != false;
    }

    private boolean isReadOnly(PropertyDefinition propertyDefinition) {
        return !this.config.isFullyEditable() && (this.config.isReadOnly() || propertyDefinition.isReadOnly() && !this.isInvalidRequiredProperty(propertyDefinition));
    }

    private boolean isInvalidRequiredProperty(PropertyDefinition propertyDefinition) {
        boolean isInvalidRequiredProperty = false;
        if (propertyDefinition instanceof PropertyDefinitionSimple && propertyDefinition.isRequired()) {
            PropertySimple propertySimple = this.propertyMap.getSimple(propertyDefinition.getName());
            String errorMessage = propertySimple.getErrorMessage();
            if (null == propertySimple.getStringValue() || "".equals(propertySimple.getStringValue()) || null != errorMessage && !"".equals(errorMessage.trim())) {
                isInvalidRequiredProperty = true;
            }
        }
        return isInvalidRequiredProperty;
    }

    private void addDebug(UIComponent component, boolean start, String methodName) {
        if (this.LOG.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("\n<!--");
            msg.append(start ? " START " : " END ");
            msg.append(this.getClass().getSimpleName());
            msg.append(methodName);
            msg.append(" -->\n ");
            FacesComponentUtility.addVerbatimText(component, msg);
        }
    }

    private static ValueExpression createPropertyValueExpression(String propertyName, String valueExpressionFormat) {
        String expression = String.format(valueExpressionFormat, propertyName);
        ValueExpression valueExpression = FacesExpressionUtility.createValueExpression(expression, String.class);
        return valueExpression;
    }
}

