/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice;

import java.io.Serializable;
import java.util.List;
import org.hornetq.api.core.SimpleString;

public class QueueInfo
implements Serializable {
    private static final long serialVersionUID = 3451892849198803182L;
    private final SimpleString routingName;
    private final SimpleString clusterName;
    private final SimpleString address;
    private final SimpleString filterString;
    private final long id;
    private List<SimpleString> filterStrings;
    private int numberOfConsumers;
    private final int distance;

    public QueueInfo(SimpleString routingName, SimpleString clusterName, SimpleString address, SimpleString filterString, long id, int distance) {
        if (routingName == null) {
            throw new IllegalArgumentException("Routing name is null");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        if (address == null) {
            throw new IllegalArgumentException("Address is null");
        }
        this.routingName = routingName;
        this.clusterName = clusterName;
        this.address = address;
        this.filterString = filterString;
        this.id = id;
        this.distance = distance;
    }

    public SimpleString getRoutingName() {
        return this.routingName;
    }

    public SimpleString getClusterName() {
        return this.clusterName;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public int getDistance() {
        return this.distance;
    }

    public long getID() {
        return this.id;
    }

    public List<SimpleString> getFilterStrings() {
        return this.filterStrings;
    }

    public void setFilterStrings(List<SimpleString> filterStrings) {
        this.filterStrings = filterStrings;
    }

    public int getNumberOfConsumers() {
        return this.numberOfConsumers;
    }

    public void incrementConsumers() {
        ++this.numberOfConsumers;
    }

    public void decrementConsumers() {
        --this.numberOfConsumers;
    }

    public String toString() {
        return "QueueInfo [routingName=" + this.routingName + ", clusterName=" + this.clusterName + ", address=" + this.address + ", filterString=" + this.filterString + ", id=" + this.id + ", filterStrings=" + this.filterStrings + ", numberOfConsumers=" + this.numberOfConsumers + ", distance=" + this.distance + "]";
    }
}

