/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.StompProtocolManager;
import org.hornetq.core.protocol.stomp.StompSubscription;
import org.hornetq.core.protocol.stomp.StompUtils;
import org.hornetq.core.server.QueueQueryResult;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.remoting.ReadyListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.UUIDGenerator;

class StompSession
implements SessionCallback {
    private static final Logger log = Logger.getLogger(StompSession.class);
    private final StompProtocolManager manager;
    private final StompConnection connection;
    private ServerSession session;
    private final OperationContext sessionContext;
    private final Map<Long, StompSubscription> subscriptions = new ConcurrentHashMap<Long, StompSubscription>();
    private final Map<Long, Pair<Long, Integer>> messagesToAck = new ConcurrentHashMap<Long, Pair<Long, Integer>>();
    private volatile boolean noLocal = false;
    private final int consumerCredits;

    StompSession(StompConnection connection, StompProtocolManager manager, OperationContext sessionContext) {
        this.connection = connection;
        this.manager = manager;
        this.sessionContext = sessionContext;
        this.consumerCredits = ConfigurationHelper.getIntProperty("stomp-consumer-credits", 10240, connection.getAcceptorUsed().getConfiguration());
    }

    void setServerSession(ServerSession session) {
        this.session = session;
    }

    public ServerSession getSession() {
        return this.session;
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    @Override
    public int sendMessage(ServerMessage serverMessage, long consumerID, int deliveryCount) {
        try {
            StompSubscription subscription = this.subscriptions.get(consumerID);
            StompFrame frame = this.createFrame(serverMessage, deliveryCount, subscription);
            int length = frame.getEncodedSize();
            if (subscription.isAutoACK()) {
                this.session.acknowledge(consumerID, serverMessage.getMessageID());
                this.session.commit();
            } else {
                this.messagesToAck.put(serverMessage.getMessageID(), new Pair<Long, Integer>(consumerID, length));
            }
            this.manager.send(this.connection, frame);
            return length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private StompFrame createFrame(ServerMessage serverMessage, int deliveryCount, StompSubscription subscription) throws UnsupportedEncodingException, Exception {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("destination", serverMessage.getAddress().toString());
        if (subscription.getID() != null) {
            headers.put("subscription", subscription.getID());
        }
        HornetQBuffer buffer = serverMessage.getBodyBufferCopy();
        int bodyPos = serverMessage.getEndOfBodyPosition() == -1 ? buffer.writerIndex() : serverMessage.getEndOfBodyPosition();
        int size = bodyPos - buffer.readerIndex();
        buffer.readerIndex(17);
        byte[] data = new byte[size];
        if (serverMessage.containsProperty("content-length") || serverMessage.getType() == 4) {
            headers.put("content-length", data.length);
            buffer.readBytes(data);
        } else {
            SimpleString text = buffer.readNullableSimpleString();
            data = text != null ? text.toString().getBytes("UTF-8") : new byte[]{};
        }
        StompFrame frame = new StompFrame("MESSAGE", headers, data);
        StompUtils.copyStandardHeadersFromMessageToFrame(serverMessage, frame, deliveryCount);
        return frame;
    }

    @Override
    public int sendLargeMessageContinuation(long consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    @Override
    public int sendLargeMessage(ServerMessage msg, long consumerID, long bodySize, int deliveryCount) {
        return 0;
    }

    @Override
    public void closed() {
    }

    @Override
    public void addReadyListener(ReadyListener listener) {
        this.connection.getTransportConnection().addReadyListener(listener);
    }

    @Override
    public void removeReadyListener(ReadyListener listener) {
        this.connection.getTransportConnection().removeReadyListener(listener);
    }

    public void acknowledge(String messageID) throws Exception {
        long id = Long.parseLong(messageID);
        Pair<Long, Integer> pair = this.messagesToAck.remove(id);
        if (pair != null) {
            long consumerID = pair.getA();
            int credits = pair.getB();
            if (this.consumerCredits != -1) {
                this.session.receiveConsumerCredits(consumerID, credits);
            }
            this.session.acknowledge(consumerID, id);
            this.session.commit();
        }
    }

    public void addSubscription(long consumerID, String subscriptionID, String clientID, String durableSubscriptionName, String destination, String selector, String ack) throws Exception {
        SimpleString queue = SimpleString.toSimpleString(destination);
        if (destination.startsWith("jms.topic")) {
            if (durableSubscriptionName != null) {
                if (clientID == null) {
                    throw new IllegalStateException("Cannot create a subscriber on the durable subscription if the client-id of the connection is not set");
                }
                queue = SimpleString.toSimpleString(clientID + "." + durableSubscriptionName);
                QueueQueryResult query = this.session.executeQueueQuery(queue);
                if (!query.isExists()) {
                    this.session.createQueue(SimpleString.toSimpleString(destination), queue, null, false, true);
                }
            } else {
                queue = UUIDGenerator.getInstance().generateSimpleStringUUID();
                this.session.createQueue(SimpleString.toSimpleString(destination), queue, null, true, false);
            }
        }
        this.session.createConsumer(consumerID, queue, SimpleString.toSimpleString(selector), false);
        StompSubscription subscription = new StompSubscription(subscriptionID, ack.equals("auto"));
        this.subscriptions.put(consumerID, subscription);
        if (subscription.isAutoACK()) {
            this.session.receiveConsumerCredits(consumerID, -1);
        } else {
            this.session.receiveConsumerCredits(consumerID, this.consumerCredits);
        }
        this.session.start();
    }

    public boolean unsubscribe(String id) throws Exception {
        Iterator<Map.Entry<Long, StompSubscription>> iterator = this.subscriptions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, StompSubscription> entry = iterator.next();
            long consumerID = entry.getKey();
            StompSubscription sub = entry.getValue();
            if (id == null || !id.equals(sub.getID())) continue;
            iterator.remove();
            this.session.closeConsumer(consumerID);
            return true;
        }
        return false;
    }

    boolean containsSubscription(String subscriptionID) {
        for (Map.Entry<Long, StompSubscription> entry : this.subscriptions.entrySet()) {
            StompSubscription sub = entry.getValue();
            if (!sub.getID().equals(subscriptionID)) continue;
            return true;
        }
        return false;
    }

    public RemotingConnection getConnection() {
        return this.connection;
    }

    public OperationContext getContext() {
        return this.sessionContext;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public void sendInternal(ServerMessageImpl message, boolean direct) throws Exception {
        if (this.connection.enableMessageID()) {
            message.putStringProperty("hqMessageId", "STOMP" + message.getMessageID());
        }
        this.session.send(message, direct);
    }
}

