/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.registry;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.TempInfo;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VFSContextConstraints;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.jboss.virtual.spi.cache.VFSCache;
import org.jboss.virtual.spi.cache.VFSCacheFactory;
import org.jboss.virtual.spi.registry.VFSRegistry;

public class DefaultVFSRegistry
extends VFSRegistry {
    private static boolean forceCanonical;
    private static Logger log;
    private Map<String, String> pathAliases = new ConcurrentHashMap<String, String>();

    protected VFSCache getCache() {
        return VFSCacheFactory.getInstance();
    }

    protected boolean isCacheable(VFSContext context) {
        Set<VFSContextConstraints> constraints = context.getConstraints();
        return constraints != null && constraints.contains((Object)VFSContextConstraints.CACHEABLE);
    }

    public void addContext(VFSContext context) {
        if (this.isCacheable(context)) {
            this.getCache().putContext(context);
        }
    }

    public void removeContext(VFSContext context) {
        if (this.isCacheable(context)) {
            this.getCache().removeContext(context);
        }
    }

    protected URIResolutionResult resolveURI(URI uri) throws IOException {
        VFSContext ctx = this.getCache().findContext(uri);
        if (ctx != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Context found immediately for: " + uri.toString() + " -> " + ctx.toString()));
            }
            return new URIResolutionResult(ctx, uri);
        }
        if (forceCanonical) {
            String path = VFSUtils.stripProtocol(uri);
            File file = new File(path);
            try {
                for (Map.Entry<String, String> entry : this.pathAliases.entrySet()) {
                    String key = entry.getKey();
                    if (!path.startsWith(key)) continue;
                    String relative = path.substring(key.length());
                    String alias = entry.getValue();
                    URI fixedURI = new URI(uri.getScheme(), uri.getHost(), alias + relative, uri.getQuery(), uri.getFragment());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Found aliased context: " + key + " -> " + alias));
                    }
                    return new URIResolutionResult(this.getCache().findContext(fixedURI), fixedURI);
                }
                String relative = "";
                while (ctx == null && file != null) {
                    URI toFind = new URI(uri.getScheme(), uri.getHost(), file.getCanonicalPath(), uri.getQuery(), uri.getFragment());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Trying to find in permanentRoots: " + toFind.toString()));
                    }
                    if ((ctx = this.getCache().findContext(toFind)) != null) continue;
                    relative = relative.length() == 0 ? file.getName() : file.getName() + "/" + relative;
                    file = file.getParentFile();
                }
                if (ctx != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Found: " + file.getCanonicalPath()));
                    }
                    this.pathAliases.put(file.getPath(), file.getCanonicalPath());
                    URI fixedURI = new URI(uri.getScheme(), uri.getHost(), file.getCanonicalPath() + "/" + relative, uri.getQuery(), uri.getFragment());
                    return new URIResolutionResult(this.getCache().findContext(fixedURI), fixedURI);
                }
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return new URIResolutionResult(null, uri);
    }

    public VFSContext getContext(URI uri) throws IOException {
        String relativePath;
        VFSContext context;
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        URIResolutionResult resolutionResult = this.resolveURI(uri);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting context in getContext(): " + resolutionResult.getURI().toString()));
        }
        if ((context = resolutionResult.getContext()) != null && (relativePath = VFSUtils.getRelativePath(context, resolutionResult.getURI())).length() == 0) {
            return context;
        }
        return null;
    }

    public VirtualFile getFile(URI uri) throws IOException {
        VFSContext context;
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        URIResolutionResult resolutionResult = this.resolveURI(uri);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting context in getFile(): " + resolutionResult.getURI().toString()));
        }
        if ((context = resolutionResult.getContext()) != null) {
            String relativePath = VFSUtils.getRelativePath(context, resolutionResult.getURI());
            TempInfo ti = context.getFurthestParentTemp(relativePath);
            if (ti != null) {
                String path = ti.getPath();
                String subpath = relativePath.substring(path.length());
                VirtualFileHandler child = this.findHandler(ti.getHandler(), subpath, true);
                if (child != null) {
                    return child.getVirtualFile();
                }
            }
            VirtualFileHandler root = context.getRoot();
            VirtualFileHandler child = this.findHandler(root, relativePath, false);
            return child.getVirtualFile();
        }
        return null;
    }

    protected VirtualFileHandler findHandler(VirtualFileHandler root, String path, boolean allowNotFound) throws IOException {
        VirtualFileHandler child = root.getChild(path);
        if (child == null && !allowNotFound) {
            List<VirtualFileHandler> children = root.getChildren(true);
            throw new IOException("Child not found " + path + " for " + root + ", available children: " + children);
        }
        return child;
    }

    static {
        log = Logger.getLogger(DefaultVFSRegistry.class);
        forceCanonical = AccessController.doPrivileged(new CheckForceCanonical());
        if (forceCanonical) {
            log.info((Object)"VFS force canonical lookup is enabled.");
        }
    }

    private static class URIResolutionResult {
        private VFSContext context;
        private URI uri;

        public URIResolutionResult(VFSContext context, URI uri) {
            this.context = context;
            this.uri = uri;
        }

        public VFSContext getContext() {
            return this.context;
        }

        public URI getURI() {
            return this.uri;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckForceCanonical
    implements PrivilegedAction<Boolean> {
        private CheckForceCanonical() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.forceCanonical", "false");
            return Boolean.valueOf(forceString);
        }
    }
}

