/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientProducerCreditManager;
import org.hornetq.core.client.impl.ClientProducerCredits;
import org.hornetq.core.client.impl.ClientProducerInternal;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.utils.ConcurrentHashSet;

public class DelegatingSession
implements ClientSessionInternal {
    private static final Logger log = Logger.getLogger(DelegatingSession.class);
    private final ClientSessionInternal session;
    private final Exception creationStack;
    private volatile boolean closed;
    private static Set<DelegatingSession> sessions = new ConcurrentHashSet<DelegatingSession>();
    public static volatile boolean debug;

    public static void dumpSessionCreationStacks() {
        log.info("**** Dumping session creation stacks ****");
        for (DelegatingSession session : sessions) {
            log.info("session created", session.creationStack);
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed && !this.session.isClosed()) {
            log.warn("I'm closing a core ClientSession you left open. Please make sure you close all ClientSessions explicitly before letting them go out of scope! " + System.identityHashCode(this));
            log.warn("The ClientSession you didn't close was created here:", this.creationStack);
            this.close();
        }
        super.finalize();
    }

    public DelegatingSession(ClientSessionInternal session) {
        this.session = session;
        this.creationStack = new Exception();
        if (debug) {
            sessions.add(this);
        }
    }

    public void acknowledge(long consumerID, long messageID) throws HornetQException {
        this.session.acknowledge(consumerID, messageID);
    }

    public void individualAcknowledge(long consumerID, long messageID) throws HornetQException {
        this.session.individualAcknowledge(consumerID, messageID);
    }

    public void addConsumer(ClientConsumerInternal consumer) {
        this.session.addConsumer(consumer);
    }

    public void addFailureListener(SessionFailureListener listener) {
        this.session.addFailureListener(listener);
    }

    public void addProducer(ClientProducerInternal producer) {
        this.session.addProducer(producer);
    }

    public ClientSession.BindingQuery bindingQuery(SimpleString address) throws HornetQException {
        return this.session.bindingQuery(address);
    }

    public void forceDelivery(long consumerID, long sequence) throws HornetQException {
        this.session.forceDelivery(consumerID, sequence);
    }

    public void cleanUp(boolean failingOver) throws Exception {
        this.session.cleanUp(failingOver);
    }

    public void close() throws HornetQException {
        this.closed = true;
        if (debug) {
            sessions.remove(this);
        }
        this.session.close();
    }

    public void commit() throws HornetQException {
        this.session.commit();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.session.commit(xid, onePhase);
    }

    public ClientMessage createMessage(boolean durable) {
        return this.session.createMessage(durable);
    }

    public ClientMessage createMessage(byte type, boolean durable, long expiration, long timestamp, byte priority) {
        return this.session.createMessage(type, durable, expiration, timestamp, priority);
    }

    public ClientMessage createMessage(byte type, boolean durable) {
        return this.session.createMessage(type, durable);
    }

    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, boolean browseOnly) throws HornetQException {
        return this.session.createConsumer(queueName, filterString, browseOnly);
    }

    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, int windowSize, int maxRate, boolean browseOnly) throws HornetQException {
        return this.session.createConsumer(queueName, filterString, windowSize, maxRate, browseOnly);
    }

    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString) throws HornetQException {
        return this.session.createConsumer(queueName, filterString);
    }

    public ClientConsumer createConsumer(SimpleString queueName) throws HornetQException {
        return this.session.createConsumer(queueName);
    }

    public ClientConsumer createConsumer(String queueName, String filterString, boolean browseOnly) throws HornetQException {
        return this.session.createConsumer(queueName, filterString, browseOnly);
    }

    public ClientConsumer createConsumer(String queueName, String filterString, int windowSize, int maxRate, boolean browseOnly) throws HornetQException {
        return this.session.createConsumer(queueName, filterString, windowSize, maxRate, browseOnly);
    }

    public ClientConsumer createConsumer(String queueName, String filterString) throws HornetQException {
        return this.session.createConsumer(queueName, filterString);
    }

    public ClientConsumer createConsumer(String queueName) throws HornetQException {
        return this.session.createConsumer(queueName);
    }

    public ClientConsumer createConsumer(SimpleString queueName, boolean browseOnly) throws HornetQException {
        return this.session.createConsumer(queueName, browseOnly);
    }

    public ClientConsumer createConsumer(String queueName, boolean browseOnly) throws HornetQException {
        return this.session.createConsumer(queueName, browseOnly);
    }

    public ClientProducer createProducer() throws HornetQException {
        return this.session.createProducer();
    }

    public ClientProducer createProducer(SimpleString address, int rate) throws HornetQException {
        return this.session.createProducer(address, rate);
    }

    public ClientProducer createProducer(SimpleString address) throws HornetQException {
        return this.session.createProducer(address);
    }

    public ClientProducer createProducer(String address) throws HornetQException {
        return this.session.createProducer(address);
    }

    public void createQueue(String address, String queueName) throws HornetQException {
        this.session.createQueue(address, queueName);
    }

    public void createQueue(SimpleString address, SimpleString queueName) throws HornetQException {
        this.session.createQueue(address, queueName);
    }

    public void createQueue(SimpleString address, SimpleString queueName, boolean durable) throws HornetQException {
        this.session.createQueue(address, queueName, durable);
    }

    public void createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws HornetQException {
        this.session.createQueue(address, queueName, filterString, durable);
    }

    public void createQueue(String address, String queueName, boolean durable) throws HornetQException {
        this.session.createQueue(address, queueName, durable);
    }

    public void createQueue(String address, String queueName, String filterString, boolean durable) throws HornetQException {
        this.session.createQueue(address, queueName, filterString, durable);
    }

    public void createTemporaryQueue(SimpleString address, SimpleString queueName, SimpleString filter) throws HornetQException {
        this.session.createTemporaryQueue(address, queueName, filter);
    }

    public void createTemporaryQueue(SimpleString address, SimpleString queueName) throws HornetQException {
        this.session.createTemporaryQueue(address, queueName);
    }

    public void createTemporaryQueue(String address, String queueName, String filter) throws HornetQException {
        this.session.createTemporaryQueue(address, queueName, filter);
    }

    public void createTemporaryQueue(String address, String queueName) throws HornetQException {
        this.session.createTemporaryQueue(address, queueName);
    }

    public void deleteQueue(SimpleString queueName) throws HornetQException {
        this.session.deleteQueue(queueName);
    }

    public void deleteQueue(String queueName) throws HornetQException {
        this.session.deleteQueue(queueName);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.session.end(xid, flags);
    }

    public void expire(long consumerID, long messageID) throws HornetQException {
        this.session.expire(consumerID, messageID);
    }

    public void forget(Xid xid) throws XAException {
        this.session.forget(xid);
    }

    public RemotingConnection getConnection() {
        return this.session.getConnection();
    }

    public int getMinLargeMessageSize() {
        return this.session.getMinLargeMessageSize();
    }

    public String getName() {
        return this.session.getName();
    }

    public int getTransactionTimeout() throws XAException {
        return this.session.getTransactionTimeout();
    }

    public int getVersion() {
        return this.session.getVersion();
    }

    public XAResource getXAResource() {
        return this.session.getXAResource();
    }

    public void preHandleFailover(CoreRemotingConnection connection) {
        this.session.preHandleFailover(connection);
    }

    public void handleFailover(CoreRemotingConnection backupConnection) {
        this.session.handleFailover(backupConnection);
    }

    public void handleReceiveContinuation(long consumerID, SessionReceiveContinuationMessage continuation) throws Exception {
        this.session.handleReceiveContinuation(consumerID, continuation);
    }

    public void handleReceiveLargeMessage(long consumerID, SessionReceiveLargeMessage message) throws Exception {
        this.session.handleReceiveLargeMessage(consumerID, message);
    }

    public void handleReceiveMessage(long consumerID, SessionReceiveMessage message) throws Exception {
        this.session.handleReceiveMessage(consumerID, message);
    }

    public boolean isAutoCommitAcks() {
        return this.session.isAutoCommitAcks();
    }

    public boolean isAutoCommitSends() {
        return this.session.isAutoCommitSends();
    }

    public boolean isBlockOnAcknowledge() {
        return this.session.isBlockOnAcknowledge();
    }

    public boolean isCacheLargeMessageClient() {
        return this.session.isCacheLargeMessageClient();
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return this.session.isSameRM(xares);
    }

    public boolean isXA() {
        return this.session.isXA();
    }

    public int prepare(Xid xid) throws XAException {
        return this.session.prepare(xid);
    }

    public ClientSession.QueueQuery queueQuery(SimpleString queueName) throws HornetQException {
        return this.session.queueQuery(queueName);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.session.recover(flag);
    }

    public void removeConsumer(ClientConsumerInternal consumer) throws HornetQException {
        this.session.removeConsumer(consumer);
    }

    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.session.removeFailureListener(listener);
    }

    public void removeProducer(ClientProducerInternal producer) {
        this.session.removeProducer(producer);
    }

    public void returnBlocking() {
        this.session.returnBlocking();
    }

    public void rollback() throws HornetQException {
        this.session.rollback();
    }

    public boolean isRollbackOnly() {
        return this.session.isRollbackOnly();
    }

    public void rollback(boolean considerLastMessageAsDelivered) throws HornetQException {
        this.session.rollback(considerLastMessageAsDelivered);
    }

    public void rollback(Xid xid) throws XAException {
        this.session.rollback(xid);
    }

    public void setSendAcknowledgementHandler(SendAcknowledgementHandler handler) {
        this.session.setSendAcknowledgementHandler(handler);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.session.setTransactionTimeout(seconds);
    }

    public void resetIfNeeded() throws HornetQException {
        this.session.resetIfNeeded();
    }

    public void start() throws HornetQException {
        this.session.start();
    }

    public void start(Xid xid, int flags) throws XAException {
        this.session.start(xid, flags);
    }

    public void stop() throws HornetQException {
        this.session.stop();
    }

    public ClientSessionFactoryInternal getSessionFactory() {
        return this.session.getSessionFactory();
    }

    public void setForceNotSameRM(boolean force) {
        this.session.setForceNotSameRM(force);
    }

    public void workDone() {
        this.session.workDone();
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        this.session.sendProducerCreditsMessage(credits, address);
    }

    public ClientProducerCredits getCredits(SimpleString address, boolean anon) {
        return this.session.getCredits(address, anon);
    }

    public void returnCredits(SimpleString address) {
        this.session.returnCredits(address);
    }

    public void handleReceiveProducerCredits(SimpleString address, int credits) {
        this.session.handleReceiveProducerCredits(address, credits);
    }

    public ClientProducerCreditManager getProducerCreditManager() {
        return this.session.getProducerCreditManager();
    }

    public void setAddress(Message message, SimpleString address) {
        this.session.setAddress(message, address);
    }

    public void setPacketSize(int packetSize) {
        this.session.setPacketSize(packetSize);
    }

    public void addMetaData(String key, String data) throws HornetQException {
        this.session.addMetaData(key, data);
    }

    @Deprecated
    public void addMetaDataV1(String key, String data) throws HornetQException {
        this.session.addMetaDataV1(key, data);
    }

    public boolean isCompressLargeMessages() {
        return this.session.isCompressLargeMessages();
    }

    public String toString() {
        return "DelegatingSession [session=" + this.session + "]";
    }

    public Channel getChannel() {
        return this.session.getChannel();
    }

    public void addUniqueMetaData(String key, String data) throws HornetQException {
        this.session.addUniqueMetaData(key, data);
    }
}

