/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCompositeValueSupport
extends AbstractMetaValue
implements CompositeValue {
    private static final long serialVersionUID = 1L;
    private Map<String, MetaValue> map = this.createMap();
    private MapCompositeMetaType mapType;

    public MapCompositeValueSupport(MetaType valueType) {
        this(null, valueType);
    }

    public MapCompositeValueSupport(Map<String, MetaValue> map, MetaType valueType) {
        this.mapType = new MapCompositeMetaType(valueType);
        if (map != null) {
            for (Map.Entry<String, MetaValue> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected Map<String, MetaValue> createMap() {
        return new HashMap<String, MetaValue>();
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(MetaValue value) {
        return this.map.containsValue(value);
    }

    @Override
    public MetaValue get(String key) {
        return this.map.get(key);
    }

    public void put(String key, MetaValue value) {
        if (!this.mapType.containsItem(key)) {
            this.mapType.addItem(key);
        }
        this.map.put(key, value);
    }

    public MetaValue remove(String key) {
        return this.map.remove(key);
    }

    @Override
    public MetaValue[] getAll(String[] keys) {
        ArrayList<MetaValue> values = new ArrayList<MetaValue>();
        if (keys != null) {
            for (String key : keys) {
                MetaValue value = this.map.get(key);
                values.add(value);
            }
        }
        MetaValue[] mvs = new MetaValue[values.size()];
        return values.toArray(mvs);
    }

    @Override
    public MapCompositeMetaType getMetaType() {
        return this.mapType;
    }

    @Override
    public Collection<MetaValue> values() {
        return this.map.values();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MapCompositeValueSupport)) {
            return false;
        }
        MapCompositeValueSupport other = (MapCompositeValueSupport)obj;
        if (!this.mapType.equals(other.getMetaType())) {
            return false;
        }
        Map<String, MetaValue> otherMap = other.map;
        if (this.map == null && otherMap == null) {
            return true;
        }
        if (this.map == null && otherMap != null) {
            return false;
        }
        return ((Object)this.map).equals(otherMap);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName()).append(":");
        buffer.append(" mapType=[").append(this.mapType).append("]");
        buffer.append(" map=[").append(this.map).append("]");
        return buffer.toString();
    }
}

