/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.impl.IDCounter;
import org.jboss.messaging.core.impl.tx.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullPersistenceManager
implements PersistenceManager {
    private static final int MAX_PEER_ID = 1023;
    private ConcurrentMap<String, IDCounter> counters = new ConcurrentHashMap<String, IDCounter>();
    private int peerID;
    private long timeMark;

    @Override
    public void addReference(long channelID, MessageReference ref, Transaction tx) throws Exception {
    }

    @Override
    public List getMessageChannelPairAcksForTx(long transactionId) throws Exception {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getMessageChannelPairRefsForTx(long transactionId) throws Exception {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getMessages(List messageIds) throws Exception {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getPagedReferenceInfos(long channelID, long orderStart, int number) throws Exception {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean idExists(String messageID) throws Exception {
        return false;
    }

    @Override
    public PersistenceManager.InitialLoadInfo loadFromStart(long channelID, int fullSize) throws Exception {
        return new PersistenceManager.InitialLoadInfo(null, null, Collections.EMPTY_LIST);
    }

    @Override
    public PersistenceManager.InitialLoadInfo mergeAndLoad(long fromChannelID, long toChannelID, int numberToLoad, long firstPagingOrder, long nextPagingOrder) throws Exception {
        return new PersistenceManager.InitialLoadInfo(null, null, Collections.EMPTY_LIST);
    }

    @Override
    public void mergeTransactions(int fromNodeID, int toNodeID) throws Exception {
    }

    @Override
    public void moveReference(long sourceChannelID, long destChannelID, MessageReference ref) throws Exception {
    }

    @Override
    public void pageReferences(long channelID, List references, boolean paged) throws Exception {
    }

    @Override
    public void removeDepagedReferences(long channelID, List refs) throws Exception {
    }

    @Override
    public void removeReference(long channelID, MessageReference ref, Transaction tx) throws Exception {
    }

    @Override
    public void setSupportsTxAge(boolean supportsTxAge) {
    }

    @Override
    public boolean supportsTxAge() {
        return false;
    }

    @Override
    public void addTransaction(Transaction tx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reserveIDBlock(String counterName, int size) throws Exception {
        this.checkServerID();
        IDCounter counter = (IDCounter)this.counters.get(counterName);
        if (counter == null) {
            ConcurrentMap<String, IDCounter> concurrentMap = this.counters;
            synchronized (concurrentMap) {
                counter = (IDCounter)this.counters.get(counterName);
                if (counter == null) {
                    counter = new IDCounter(this);
                    this.counters.put(counterName, counter);
                }
            }
        }
        long idStart = counter.reserveAndGetNextId(size);
        return idStart;
    }

    private void checkServerID() throws Exception {
        if (this.peerID > 1023) {
            throw new Exception("ServerPeerID " + this.peerID + " exceeding " + 1023);
        }
        if (this.peerID < 0) {
            throw new Exception("ServerPeerID cannot have negative values");
        }
    }

    @Override
    public List retrievePreparedTransactions() throws Exception {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void updateDeliveryCount(long channelID, MessageReference ref) throws Exception {
    }

    @Override
    public void updatePageOrder(long channelID, List references) throws Exception {
    }

    @Override
    public void updateReferencesNotPagedInRange(long channelID, long orderStart, long orderEnd, long num) throws Exception {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    public void initCounter(int serverPeerID, long serverStartTime) {
        this.setPeerID(serverPeerID);
        this.setTimeMark(serverStartTime);
    }

    public void setPeerID(int peerID) {
        this.peerID = peerID;
    }

    public int getPeerID() {
        return this.peerID;
    }

    public void setTimeMark(long timeMark) {
        this.timeMark = timeMark;
    }

    public long getTimeMark() {
        return this.timeMark;
    }

    @Override
    public void dropChannelMessages(long channelID) throws Exception {
    }

    @Override
    public void mergeChannelMessage(long fromID, long toID) throws Exception {
    }

    @Override
    public void updateMessageState(long channelID, MessageReference ref, String state) throws Exception {
    }

    @Override
    public List<PersistenceManager.ReferenceInfo> claimMessagesInSuck(long channelID) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public boolean checkConnection() {
        return true;
    }
}

