/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.core.timer;

import javax.ejb.Timer;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.aop.AbstractInterceptor;
import org.jboss.ejb3.core.timer.TimerCallbackInvocationHelper;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;

public class EnlistTimerInterceptor
extends AbstractInterceptor {
    private static final Logger log = Logger.getLogger(EnlistTimerInterceptor.class);
    private final TransactionManager tm = TxUtil.getTransactionManager();

    public Object invoke(Invocation invocation) throws Throwable {
        Timer timer = TimerCallbackInvocationHelper.getTimer(invocation);
        if (timer == null) {
            throw new IllegalStateException("EJBTHREE-2035: timer not set on invocation");
        }
        if (timer instanceof Synchronization) {
            Transaction tx = this.getTransaction();
            if (tx != null && tx.getStatus() != 1) {
                tx.registerSynchronization((Synchronization)timer);
            }
        } else {
            log.warn((Object)"EJBTHREE-2035: Timer does not implement Synchronization, transaction semantics will not work");
        }
        return invocation.invokeNext();
    }

    private Transaction getTransaction() throws SystemException {
        return this.tm.getTransaction();
    }
}

