/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.EJBObject;
import javax.ejb.Remote;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.lang.ClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteProcessor
extends AbstractFinderUser
implements Processor<JBossSessionBeanMetaData, Class<?>> {
    public RemoteProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    protected void addBusinessInterface(JBossSessionBeanMetaData metaData, Class<?> businessInterface) {
        if (EJBObject.class.isAssignableFrom(businessInterface)) {
            throw new IllegalStateException("EJB 3.0 Core Specification Violation (4.6.6): The session bean\ufffd\ufffd\ufffds business interface " + businessInterface + " must not extend the javax.ejb.EJBObject interface.");
        }
        if (metaData.getBusinessRemotes() == null) {
            metaData.setBusinessRemotes(new BusinessRemotesMetaData());
        }
        metaData.getBusinessRemotes().add(businessInterface.getName());
    }

    @Override
    public void process(JBossSessionBeanMetaData metaData, Class<?> type) {
        Remote remote = this.finder.getAnnotation(type, Remote.class);
        if (remote == null) {
            return;
        }
        if (type.isInterface()) {
            this.addBusinessInterface(metaData, type);
        } else if (remote.value() == null || remote.value().length == 0) {
            Class<?> businessInterface = ClassHelper.getDefaultInterface(type);
            this.addBusinessInterface(metaData, businessInterface);
        } else {
            for (Class businessInterface : remote.value()) {
                this.addBusinessInterface(metaData, businessInterface);
            }
        }
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Remote.class);
    }
}

