/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.jboss.messaging.util.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    public ObjectInputStreamWithClassLoader(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        ClassLoader loader = SecurityActions.getTCL();
        try {
            Class<?> clazz = loader.loadClass(name);
            if (clazz == null) {
                return super.resolveClass(desc);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader loader = SecurityActions.getTCL();
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        try {
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> cl = Class.forName(interfaces[i], false, loader);
                if ((cl.getModifiers() & 1) == 0) {
                    if (hasNonPublicInterface) {
                        if (nonPublicLoader != cl.getClassLoader()) {
                            throw new IllegalAccessError("conflicting non-public interface class loaders");
                        }
                    } else {
                        nonPublicLoader = cl.getClassLoader();
                        hasNonPublicInterface = true;
                    }
                }
                classObjs[i] = cl;
            }
            try {
                return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : loader, classObjs);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }
        catch (ClassNotFoundException cnfe) {
            return super.resolveProxyClass(interfaces);
        }
    }
}

