/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.sei;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.server.InvokerTube;
import com.sun.xml.ws.server.sei.DispatchException;
import com.sun.xml.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.ws.server.sei.EndpointMethodDispatcherGetter;
import com.sun.xml.ws.server.sei.EndpointMethodHandler;
import java.text.MessageFormat;
import java.util.List;

public class SEIInvokerTube
extends InvokerTube {
    private final SOAPVersion soapVersion;
    private final WSBinding binding;
    private final AbstractSEIModelImpl model;
    private final List<EndpointMethodDispatcher> dispatcherList;

    public SEIInvokerTube(AbstractSEIModelImpl model, Invoker invoker, WSBinding binding) {
        super(invoker);
        this.soapVersion = binding.getSOAPVersion();
        this.binding = binding;
        this.model = model;
        EndpointMethodDispatcherGetter methodDispatcherGetter = new EndpointMethodDispatcherGetter(model, binding, this);
        this.dispatcherList = methodDispatcherGetter.getDispatcherList();
    }

    @Override
    @NotNull
    public NextAction processRequest(@NotNull Packet req) {
        for (EndpointMethodDispatcher dispatcher : this.dispatcherList) {
            EndpointMethodHandler handler;
            try {
                handler = dispatcher.getEndpointMethodHandler(req);
            }
            catch (DispatchException e) {
                return this.doReturnWith(req.createServerResponse(e.fault, this.model.getPort(), null, this.binding));
            }
            if (handler == null) continue;
            Packet res = handler.invoke(req);
            assert (res != null);
            return this.doReturnWith(res);
        }
        String err = MessageFormat.format("Request=[SOAPAction={0},Payload='{'{1}'}'{2}]", req.soapAction, req.getMessage().getPayloadNamespaceURI(), req.getMessage().getPayloadLocalPart());
        String faultString = ServerMessages.DISPATCH_CANNOT_FIND_METHOD(err);
        Message faultMsg = SOAPFaultBuilder.createSOAPFaultMessage(this.binding.getSOAPVersion(), faultString, this.binding.getSOAPVersion().faultCodeClient);
        return this.doReturnWith(req.createServerResponse(faultMsg, this.model.getPort(), null, this.binding));
    }

    @Override
    @NotNull
    public NextAction processResponse(@NotNull Packet response) {
        throw new IllegalStateException("InovkerPipe's processResponse shouldn't be called.");
    }

    @Override
    @NotNull
    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("InovkerPipe's processException shouldn't be called.");
    }
}

