/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.deployment.AnnotationDeploymentHandler;
import org.jboss.seam.deployment.ClassDescriptor;
import org.jboss.seam.deployment.ComponentDeploymentHandler;
import org.jboss.seam.deployment.ComponentsXmlDeploymentHandler;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.deployment.DotComponentDotXmlDeploymentHandler;
import org.jboss.seam.deployment.FileDescriptor;
import org.jboss.seam.deployment.NamespaceDeploymentHandler;
import org.jboss.seam.deployment.SeamDeploymentProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardDeploymentStrategy
extends DeploymentStrategy {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private ServletContext servletContext;
    public static final String[] RESOURCE_NAMES = new String[]{"seam.properties", "META-INF/seam.properties", "META-INF/components.xml"};
    public static final String NAME = "deploymentStrategy";
    public static final String HANDLERS_KEY = "org.jboss.seam.deployment.deploymentHandlers";
    private ComponentDeploymentHandler componentDeploymentHandler;
    private ComponentsXmlDeploymentHandler componentsXmlDeploymentHandler;
    private NamespaceDeploymentHandler namespaceDeploymentHandler;
    private AnnotationDeploymentHandler annotationDeploymentHandler;
    private DotComponentDotXmlDeploymentHandler dotComponentDotXmlDeploymentHandler;

    public StandardDeploymentStrategy(ClassLoader classLoader, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.componentDeploymentHandler = new ComponentDeploymentHandler();
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.ComponentDeploymentHandler", this.componentDeploymentHandler);
        this.componentsXmlDeploymentHandler = new ComponentsXmlDeploymentHandler();
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.ComponentsXmlDeploymentHandler", this.componentsXmlDeploymentHandler);
        this.dotComponentDotXmlDeploymentHandler = new DotComponentDotXmlDeploymentHandler();
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.DotComponentDotXmlDeploymentHandler", this.dotComponentDotXmlDeploymentHandler);
        this.namespaceDeploymentHandler = new NamespaceDeploymentHandler();
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.NamespaceDeploymentHandler", this.namespaceDeploymentHandler);
        this.annotationDeploymentHandler = new AnnotationDeploymentHandler(new SeamDeploymentProperties(classLoader).getPropertyValues("org.jboss.seam.deployment.annotationTypes"), classLoader);
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.AnnotationDeploymentHandler", this.annotationDeploymentHandler);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    protected String getDeploymentHandlersKey() {
        return HANDLERS_KEY;
    }

    public Set<ClassDescriptor> getAnnotatedComponents() {
        return Collections.unmodifiableSet(this.componentDeploymentHandler.getClasses());
    }

    public Set<FileDescriptor> getXmlComponents() {
        HashSet<FileDescriptor> fileDescriptors = new HashSet<FileDescriptor>();
        fileDescriptors.addAll(this.componentsXmlDeploymentHandler.getResources());
        fileDescriptors.addAll(this.dotComponentDotXmlDeploymentHandler.getResources());
        return Collections.unmodifiableSet(fileDescriptors);
    }

    public Set<Package> getScannedNamespaces() {
        return Collections.unmodifiableSet(this.namespaceDeploymentHandler.getPackages());
    }

    public Map<String, Set<Class<?>>> getAnnotatedClasses() {
        return Collections.unmodifiableMap(this.annotationDeploymentHandler.getClassMap());
    }

    @Override
    public void scan() {
        this.getScanner().scanResources(RESOURCE_NAMES);
        this.getScanner().scanDirectories(this.getFiles().toArray(new File[0]));
        this.postScan();
    }

    public static StandardDeploymentStrategy instance() {
        if (Contexts.getEventContext().isSet(NAME)) {
            return (StandardDeploymentStrategy)Contexts.getEventContext().get(NAME);
        }
        return null;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

