/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.model.DataModel;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.faces.DataModels;
import org.jboss.seam.framework.PersistenceController;
import org.jboss.seam.persistence.QueryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query<T, E>
extends PersistenceController<T> {
    private static final Pattern SUBJECT_PATTERN = Pattern.compile("^select\\s+(\\w+(?:\\s*\\.\\s*\\w+)*?)(?:\\s*,\\s*(\\w+(?:\\s*\\.\\s*\\w+)*?))*?\\s+from", 2);
    private static final Pattern FROM_PATTERN = Pattern.compile("(^|\\s)(from)\\s", 2);
    private static final Pattern WHERE_PATTERN = Pattern.compile("\\s(where)\\s", 2);
    private static final Pattern ORDER_PATTERN = Pattern.compile("\\s(order)(\\s)+by\\s", 2);
    private static final Pattern GROUP_PATTERN = Pattern.compile("\\s(group)(\\s)+by\\s", 2);
    private static final Pattern ORDER_COLUMN_PATTERN = Pattern.compile("^\\w+(\\.\\w+)*$");
    private static final String DIR_ASC = "asc";
    private static final String DIR_DESC = "desc";
    private static final String LOGIC_OPERATOR_AND = "and";
    private static final String LOGIC_OPERATOR_OR = "or";
    private String ejbql;
    private Integer firstResult;
    private Integer maxResults;
    private List<Expressions.ValueExpression> restrictions = new ArrayList<Expressions.ValueExpression>(0);
    private String order;
    private String orderColumn;
    private String orderDirection;
    private String restrictionLogicOperator;
    private String groupBy;
    private boolean useWildcardAsCountQuerySubject = true;
    private DataModel dataModel;
    private String parsedEjbql;
    private List<Expressions.ValueExpression> queryParameters;
    private List<String> parsedRestrictions;
    private List<Expressions.ValueExpression> restrictionParameters;
    private List<Object> queryParameterValues;
    private List<Object> restrictionParameterValues;

    public abstract List<E> getResultList();

    public abstract E getSingleResult();

    public abstract Long getResultCount();

    @Create
    public void validate() {
        if (this.getEjbql() == null) {
            throw new IllegalStateException("ejbql is null");
        }
    }

    @Transactional
    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = DataModels.instance().getDataModel(this);
        }
        return this.dataModel;
    }

    public E getDataModelSelection() {
        return (E)this.getDataModel().getRowData();
    }

    public int getDataModelSelectionIndex() {
        return this.getDataModel().getRowIndex();
    }

    public void refresh() {
        this.clearDataModel();
    }

    @Transactional
    public void last() {
        this.setFirstResult(this.getLastFirstResult().intValue());
    }

    public void next() {
        this.setFirstResult(this.getNextFirstResult());
    }

    public void previous() {
        this.setFirstResult(this.getPreviousFirstResult());
    }

    public void first() {
        this.setFirstResult(0);
    }

    protected void clearDataModel() {
        this.dataModel = null;
    }

    @Transactional
    public Long getLastFirstResult() {
        Integer pc = this.getPageCount();
        return pc == null ? null : Long.valueOf((pc.longValue() - 1L) * (long)this.getMaxResults().intValue());
    }

    public int getNextFirstResult() {
        Integer fr = this.getFirstResult();
        return (fr == null ? 0 : fr) + this.getMaxResults();
    }

    public int getPreviousFirstResult() {
        Integer fr = this.getFirstResult();
        Integer mr = this.getMaxResults();
        return mr >= (fr == null ? 0 : fr) ? 0 : fr - mr;
    }

    @Transactional
    public Integer getPageCount() {
        if (this.getMaxResults() == null) {
            return null;
        }
        int rc = this.getResultCount().intValue();
        int mr = this.getMaxResults();
        int pages = rc / mr;
        return rc % mr == 0 ? pages : pages + 1;
    }

    protected void parseEjbql() {
        if (this.parsedEjbql == null || this.parsedRestrictions == null) {
            QueryParser qp = new QueryParser(this.getEjbql());
            this.queryParameters = qp.getParameterValueBindings();
            this.parsedEjbql = qp.getEjbql();
            List<Expressions.ValueExpression> restrictionFragments = this.getRestrictions();
            this.parsedRestrictions = new ArrayList<String>(restrictionFragments.size());
            this.restrictionParameters = new ArrayList<Expressions.ValueExpression>(restrictionFragments.size());
            for (Expressions.ValueExpression restriction : restrictionFragments) {
                QueryParser rqp = new QueryParser(restriction.getExpressionString(), this.queryParameters.size() + this.restrictionParameters.size());
                if (rqp.getParameterValueBindings().size() != 1) {
                    throw new IllegalArgumentException("there should be exactly one value binding in a restriction: " + restriction);
                }
                this.parsedRestrictions.add(rqp.getEjbql());
                this.restrictionParameters.addAll(rqp.getParameterValueBindings());
            }
        }
    }

    protected String getRenderedEjbql() {
        StringBuilder builder = new StringBuilder().append(this.parsedEjbql);
        for (int i = 0; i < this.getRestrictions().size(); ++i) {
            Object parameterValue = this.restrictionParameters.get(i).getValue();
            if (!this.isRestrictionParameterSet(parameterValue)) continue;
            if (WHERE_PATTERN.matcher(builder).find()) {
                builder.append(" ").append(this.getRestrictionLogicOperator()).append(" ");
            } else {
                builder.append(" where ");
            }
            builder.append(this.parsedRestrictions.get(i));
        }
        if (this.getGroupBy() != null) {
            builder.append(" group by ").append(this.getGroupBy());
        }
        if (this.getOrder() != null) {
            builder.append(" order by ").append(this.getOrder());
        }
        return builder.toString();
    }

    protected boolean isRestrictionParameterSet(Object parameterValue) {
        return parameterValue != null && !"".equals(parameterValue) && (!(parameterValue instanceof Collection) || !((Collection)parameterValue).isEmpty());
    }

    protected String getCountEjbql() {
        String subject;
        int whereLoc;
        String ejbql = this.getRenderedEjbql();
        Matcher fromMatcher = FROM_PATTERN.matcher(ejbql);
        if (!fromMatcher.find()) {
            throw new IllegalArgumentException("no from clause found in query");
        }
        int fromLoc = fromMatcher.start(2);
        Matcher orderMatcher = ORDER_PATTERN.matcher(ejbql);
        int orderLoc = orderMatcher.find() ? orderMatcher.start(1) : ejbql.length();
        Matcher groupMatcher = GROUP_PATTERN.matcher(ejbql);
        int groupLoc = groupMatcher.find() ? groupMatcher.start(1) : orderLoc;
        Matcher whereMatcher = WHERE_PATTERN.matcher(ejbql);
        int n = whereLoc = whereMatcher.find() ? whereMatcher.start(1) : groupLoc;
        if (this.getGroupBy() != null) {
            subject = "distinct " + this.getGroupBy();
        } else if (this.useWildcardAsCountQuerySubject) {
            subject = "*";
        } else {
            Matcher subjectMatcher = SUBJECT_PATTERN.matcher(ejbql);
            if (subjectMatcher.find()) {
                subject = subjectMatcher.group(1);
            } else {
                throw new IllegalStateException("invalid select clause for query");
            }
        }
        return new StringBuilder(ejbql.length() + 15).append("select count(").append(subject).append(") ").append(ejbql.substring(fromLoc, whereLoc).replace("join fetch", "join")).append(ejbql.substring(whereLoc, groupLoc)).toString().trim();
    }

    public String getEjbql() {
        return this.ejbql;
    }

    public void setEjbql(String ejbql) {
        this.ejbql = ejbql;
        this.parsedEjbql = null;
        this.refresh();
    }

    public Integer getFirstResult() {
        return this.firstResult;
    }

    public boolean isPreviousExists() {
        return this.getFirstResult() != null && this.getFirstResult() != 0;
    }

    public abstract boolean isNextExists();

    public boolean isPaginated() {
        return this.isNextExists() || this.isPreviousExists();
    }

    public void setFirstResult(Integer firstResult) {
        this.firstResult = firstResult;
        this.refresh();
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        this.refresh();
    }

    public List<Expressions.ValueExpression> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<Expressions.ValueExpression> restrictions) {
        this.restrictions = restrictions;
        this.parsedRestrictions = null;
        this.refresh();
    }

    public void setRestrictionExpressionStrings(List<String> expressionStrings) {
        Expressions expressions = new Expressions();
        ArrayList<Expressions.ValueExpression> restrictionVEs = new ArrayList<Expressions.ValueExpression>(expressionStrings.size());
        for (String expressionString : expressionStrings) {
            restrictionVEs.add(expressions.createValueExpression(expressionString));
        }
        this.setRestrictions(restrictionVEs);
    }

    public List<String> getRestrictionExpressionStrings() {
        ArrayList<String> expressionStrings = new ArrayList<String>();
        for (Expressions.ValueExpression restriction : this.getRestrictions()) {
            expressionStrings.add(restriction.getExpressionString());
        }
        return expressionStrings;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getOrder() {
        String column = this.getOrderColumn();
        if (column == null) {
            return this.order;
        }
        String direction = this.getOrderDirection();
        if (direction == null) {
            return column;
        }
        return column + ' ' + direction;
    }

    public void setOrder(String order) {
        this.order = order;
        this.refresh();
    }

    public String getOrderDirection() {
        return this.orderDirection;
    }

    public void setOrderDirection(String orderDirection) {
        this.orderDirection = this.sanitizeOrderDirection(orderDirection);
    }

    private String sanitizeOrderDirection(String direction) {
        if (direction == null || direction.length() == 0) {
            return null;
        }
        if (direction.equalsIgnoreCase(DIR_ASC)) {
            return DIR_ASC;
        }
        if (direction.equalsIgnoreCase(DIR_DESC)) {
            return DIR_DESC;
        }
        throw new IllegalArgumentException("invalid order direction");
    }

    public String getOrderColumn() {
        return this.orderColumn;
    }

    public void setOrderColumn(String orderColumn) {
        this.orderColumn = this.sanitizeOrderColumn(orderColumn);
    }

    private String sanitizeOrderColumn(String columnName) {
        if (columnName == null || columnName.trim().length() == 0) {
            return null;
        }
        if (ORDER_COLUMN_PATTERN.matcher(columnName).find()) {
            return columnName;
        }
        throw new IllegalArgumentException("invalid order column (\"" + columnName + "\" must match the regular expression \"" + ORDER_COLUMN_PATTERN + "\")");
    }

    public String getRestrictionLogicOperator() {
        return this.restrictionLogicOperator != null ? this.restrictionLogicOperator : LOGIC_OPERATOR_AND;
    }

    public void setRestrictionLogicOperator(String operator) {
        this.restrictionLogicOperator = this.sanitizeRestrictionLogicOperator(operator);
    }

    private String sanitizeRestrictionLogicOperator(String operator) {
        if (operator == null || operator.trim().length() == 0) {
            return LOGIC_OPERATOR_AND;
        }
        if (!LOGIC_OPERATOR_AND.equals(operator) && !LOGIC_OPERATOR_OR.equals(operator)) {
            throw new IllegalArgumentException("Invalid restriction logic operator: " + operator);
        }
        return operator;
    }

    protected List<Expressions.ValueExpression> getQueryParameters() {
        return this.queryParameters;
    }

    protected List<Expressions.ValueExpression> getRestrictionParameters() {
        return this.restrictionParameters;
    }

    private static boolean isAnyParameterDirty(List<Expressions.ValueExpression> valueBindings, List<Object> lastParameterValues) {
        if (lastParameterValues == null) {
            return true;
        }
        for (int i = 0; i < valueBindings.size(); ++i) {
            Object parameterValue = valueBindings.get(i).getValue();
            Object lastParameterValue = lastParameterValues.get(i);
            if ("".equals(parameterValue)) {
                parameterValue = null;
            }
            if ("".equals(lastParameterValue)) {
                lastParameterValue = null;
            }
            if (parameterValue == lastParameterValue || parameterValue != null && parameterValue.equals(lastParameterValue)) continue;
            return true;
        }
        return false;
    }

    private static List<Object> getParameterValues(List<Expressions.ValueExpression> valueBindings) {
        ArrayList<Object> values = new ArrayList<Object>(valueBindings.size());
        for (int i = 0; i < valueBindings.size(); ++i) {
            values.add(valueBindings.get(i).getValue());
        }
        return values;
    }

    protected void evaluateAllParameters() {
        this.setQueryParameterValues(Query.getParameterValues(this.getQueryParameters()));
        this.setRestrictionParameterValues(Query.getParameterValues(this.getRestrictionParameters()));
    }

    protected boolean isAnyParameterDirty() {
        return Query.isAnyParameterDirty(this.getQueryParameters(), this.getQueryParameterValues()) || Query.isAnyParameterDirty(this.getRestrictionParameters(), this.getRestrictionParameterValues());
    }

    protected List<Object> getQueryParameterValues() {
        return this.queryParameterValues;
    }

    protected void setQueryParameterValues(List<Object> queryParameterValues) {
        this.queryParameterValues = queryParameterValues;
    }

    protected List<Object> getRestrictionParameterValues() {
        return this.restrictionParameterValues;
    }

    protected void setRestrictionParameterValues(List<Object> restrictionParameterValues) {
        this.restrictionParameterValues = restrictionParameterValues;
    }

    protected List<E> truncResultList(List<E> results) {
        Integer mr = this.getMaxResults();
        if (mr != null && results.size() > mr) {
            return results.subList(0, mr);
        }
        return results;
    }

    protected boolean isUseWildcardAsCountQuerySubject() {
        return this.useWildcardAsCountQuerySubject;
    }

    protected void setUseWildcardAsCountQuerySubject(boolean useCompliantCountQuerySubject) {
        this.useWildcardAsCountQuerySubject = useCompliantCountQuerySubject;
    }
}

