/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.security.permission.Identifier;
import org.jboss.seam.security.permission.IdentifierStrategy;

public class ClassIdentifierStrategy
implements IdentifierStrategy,
Serializable {
    private Map<Class, String> identifierNames = new ConcurrentHashMap<Class, String>();

    public boolean canIdentify(Class targetClass) {
        return Class.class.equals((Object)targetClass);
    }

    public String getIdentifier(Object target) {
        if (!(target instanceof Class)) {
            throw new IllegalArgumentException("Target [" + target + "] must be instance of Class");
        }
        return this.getIdentifierName((Class)target);
    }

    private String getIdentifierName(Class cls) {
        if (!this.identifierNames.containsKey(cls)) {
            Identifier identifier;
            String name = null;
            if (cls.isAnnotationPresent(Identifier.class) && (identifier = cls.getAnnotation(Identifier.class)).name() != null && !"".equals(identifier.name().trim())) {
                name = identifier.name();
            }
            if (name == null) {
                name = Seam.getComponentName(cls);
            }
            if (name == null) {
                name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
            }
            this.identifierNames.put(cls, name);
            return name;
        }
        return this.identifierNames.get(cls);
    }
}

