/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.parsing.DocumentAdapter;
import com.meterware.httpunit.parsing.HTMLParser;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import com.meterware.httpunit.parsing.JTidyPrintWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

class JTidyHTMLParser
implements HTMLParser {
    private static final char NBSP = '\u00a0';
    private static final String UTF_ENCODING = "UTF-8";

    JTidyHTMLParser() {
    }

    @Override
    public void parse(URL pageURL, String pageText, DocumentAdapter adapter) throws IOException, SAXException {
        try {
            adapter.setRootNode(JTidyHTMLParser.getParser(pageURL).parseDOM((InputStream)new ByteArrayInputStream(pageText.getBytes(UTF_ENCODING)), null));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding failed");
        }
    }

    @Override
    public String getCleanedText(String string) {
        return string == null ? "" : string.replace('\u00a0', ' ');
    }

    @Override
    public boolean supportsPreserveTagCase() {
        return false;
    }

    @Override
    public boolean supportsReturnHTMLDocument() {
        return false;
    }

    @Override
    public boolean supportsParserWarnings() {
        return true;
    }

    private static Tidy getParser(URL url) {
        Tidy tidy = new Tidy();
        tidy.setCharEncoding(3);
        tidy.setQuiet(true);
        tidy.setShowWarnings(HTMLParserFactory.isParserWarningsEnabled());
        if (!HTMLParserFactory.getHTMLParserListeners().isEmpty()) {
            tidy.setErrout((PrintWriter)new JTidyPrintWriter(url));
        }
        return tidy;
    }
}

