/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.jboss.tools.buildmagic.task.MissingAttributeException;
import org.jboss.tools.buildmagic.task.config.Library;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public class LibrarySet
extends Task {
    protected final TaskLogger log = new TaskLogger(this);
    protected String pathID;
    protected File root;
    protected List libraries;
    protected Path classpath;

    public void setPathID(String pathID) {
        this.pathID = pathID;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public Library createLibrary() {
        Library lib = (Library)this.getProject().createTask("library");
        if (this.libraries == null) {
            this.libraries = new ArrayList();
        }
        this.libraries.add(lib);
        return lib;
    }

    public Library createModuleLibrary() {
        Library lib = (Library)this.getProject().createTask("modulelibrary");
        if (this.libraries == null) {
            this.libraries = new ArrayList();
        }
        this.libraries.add(lib);
        return lib;
    }

    protected void validate() throws BuildException {
        if (this.pathID == null) {
            throw new MissingAttributeException("pathID", this);
        }
    }

    public void execute() throws BuildException {
        if (this.classpath != null) {
            return;
        }
        this.validate();
        this.log.debug("pathID: " + this.pathID);
        this.log.debug("root: " + this.root);
        this.classpath = new Path(this.getProject());
        if (this.libraries != null) {
            Iterator iter = this.libraries.iterator();
            while (iter.hasNext()) {
                Library lib = (Library)((Object)iter.next());
                if (this.root != null) {
                    lib.setRoot(this.root);
                }
                lib.execute();
                this.classpath.append(lib.getClasspath());
            }
            this.log.debug("classpath: " + this.classpath);
        }
        Hashtable refs = this.getProject().getReferences();
        refs.put(this.pathID, this.classpath);
        this.pathID = null;
        this.root = null;
        this.libraries = null;
    }

    public Path getClasspath() {
        return this.classpath;
    }
}

