/*
 * JBoss, Home of Professional Open Source.
 * Copyright (c) 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 */
public class HttpInvokerHelper
{
   /**
    * Does the distribution contain httpha-invoker.sar?
    */
   private static boolean hasHttpHAInvoker()
   {
      // do some smart test to detect httpha-invoker.sar or just assert we're not running EWP
      return !Boolean.getBoolean("jbosstest.ewp");
   }

   /**
    * If the distribution does not contain httpha-invoker.sar return the path to it
    * otherwise return null.
    * @return null or the path to httpha-invoker.sar
    */
   public static String withHttpHAInvoker()
   {
      // make a wild guess where httpha-invoker.sar might be, you never know your luck
      return hasHttpHAInvoker() ? null : "../../../varia/output/lib/httpha-invoker.sar";
   }
}
