/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.jpa.jbpapp9336.unit;


import junit.framework.Test;

import org.jboss.test.JBossTestCase;
import org.jboss.test.jpa.jbpapp9336.EntityWithHandlerAttribute;
import org.jboss.test.jpa.jbpapp9336.HandlerTest;
import org.jboss.test.jpa.jbpapp9336.HandlerTestBean;

/**
 * @author Navin Surtani (navssurtani)
 *
 * Test class used to validate an upgrade for JBPAPP-9336.
 * 
 * Because of the fact that upgrading the Javassist dependency within EAP 5.x to 3.16 causes a build failure due to AOP,
 * a service pack for Javassist 3.12 was created. This test is used in order to validate that the upgrade works fine in
 * conjunction with the bug caused within Hibernate for HHH-5731. 
 */
public class UseGetHandlerUnitTestCase extends JBossTestCase{

    private static final String DEPLOYMENT_NAME = "jbpapp-9336.jar";
    
    
    public UseGetHandlerUnitTestCase(String name) {
        super(name);
    }
    
    public static Test suite() throws Exception {
        return getDeploySetup(UseGetHandlerUnitTestCase.class, DEPLOYMENT_NAME);
    }
    
    public void testGetHandler() throws Exception {
          
        HandlerTest handlerTest = (HandlerTest) this.getInitialContext().lookup("HandlerTestBean/remote");
        
        // Create a few ewha (s).
        EntityWithHandlerAttribute entityOne = handlerTest.createEntityWithHandlerAttribute("handler-one");
        EntityWithHandlerAttribute entityTwo = handlerTest.createEntityWithHandlerAttribute("handler-two");
        
        // Obtain the id's of these ewha instances:
        Long idOne = entityOne.getId();
        Long idTwo = entityTwo.getId();
        
        // Now try and obtain these guys using the id's.
        System.out.println(handlerTest.loadEntityWithHandlerAttribute(idOne).getHandler());
        System.out.println(handlerTest.loadEntityWithHandlerAttribute(idTwo).getHandler());
        assert handlerTest.loadEntityWithHandlerAttribute(idOne).getHandler().equals("handler-one");
        assert handlerTest.loadEntityWithHandlerAttribute(idTwo).getHandler().equals("handler-two");
    
    }
    
    

}
