@echo off
REM JBoss, the OpenSource webOS
REM
REM Distributable under LGPL license.
REM See terms of license at gnu.org.
REM
REM -------------------------------------------------------------------------
REM JBoss Service Script for Windows
REM -------------------------------------------------------------------------

@if not "%ECHO%" == "" echo %ECHO%
@if "%OS%" == "Windows_NT" setlocal
set DIRNAME=%CD%

REM Read an optional configuration file located in the current (native/sbin) directory
if "x%RUN_CONF%" == "x" (
   set "RUN_CONF=%DIRNAME%\run.conf.bat"
)
if exist "%RUN_CONF%" (
   call "%RUN_CONF%" %*
)

REM Modify these to set the profile to use and the bind address
set SVCPROFILE=default
set SVCBINDIP=127.0.0.1

REM To run multiple instances, create a copy of the service.bat and modify SVCNAME/SVCDISP/SVCDESC
REM
REM VERSION, VERSION_MAJOR and VERSION_MINOR are populated
REM during the build with ant filter.
REM
set SVCNAME=JBAS52SVC
set SVCDISP=JBoss Application Server 5.2
set SVCDESC=JBoss Application Server 5.2.0/Platform: Windows NT
set NOPAUSE=Y

REM Find the JBOSS-AS home
if exist "..\..\jboss-as\bin\run.bat" (
  set "EAPPATH=..\..\jboss-as\bin"
) else if exist "..\bin\run.bat" (
  set "EAPPATH=..\bin"
) else if exist "run.bat" (
  set "EAPPATH=."
)

if not "x%EAPPATH%" == "x" goto getSvcPath
echo Cannot find the run.bat.
echo Invalid installation
goto cmdEnd

REM Translate to an absolute path
:getSvcPath
pushd %EAPPATH%
set "SVCPATH=%CD%"
popd

set EAPPATH=

REM Figure out the running mode

if /I "%1" == "install"   goto cmdInstall
if /I "%1" == "uninstall" goto cmdUninstall
if /I "%1" == "start"     goto cmdStart
if /I "%1" == "stop"      goto cmdStop
if /I "%1" == "restart"   goto cmdRestart
if /I "%1" == "signal"    goto cmdSignal
echo Usage: service install^|uninstall^|start^|stop^|restart^|signal
goto cmdEnd

REM jbosssvc return values
REM ERR_RET_USAGE           1
REM ERR_RET_VERSION         2
REM ERR_RET_INSTALL         3
REM ERR_RET_REMOVE          4
REM ERR_RET_PARAMS          5
REM ERR_RET_MODE            6

:errExplain
if errorlevel 1 echo Invalid command line parameters
if errorlevel 2 echo Failed installing %SVCDISP%
if errorlevel 4 echo Failed removing %SVCDISP%
if errorlevel 6 echo Unknown service mode for %SVCDISP%
goto cmdEnd

:cmdInstall
echo Installing %SVCDISP%
echo Using %SVCPATH%\run.bat

REM %0 == service.bat, but allows you to have multiple services by duplicating the service.bat file
jbosssvc.exe -imwdc %SVCNAME% "%DIRNAME%" "%SVCDISP%" "%SVCDESC%" %0
if not errorlevel 0 goto errExplain
goto cmdEnd

:cmdUninstall
jbosssvc.exe -u %SVCNAME%
if not errorlevel 0 goto errExplain
goto cmdEnd

:cmdStart
REM Executed on service start
del .r.lock 2>&1 | findstr /C:"being used" > nul
if not errorlevel 1 (
  echo Could not continue. Locking file already in use.
  goto cmdEnd
)

REM initialise the log file
echo %SVCPATH% > run.log

REM Read the JBoss configuration file which sets JAVA_OPTS. First try to find it in the selected profile, otherwise use the global one
REM note the different var names to get around cmd.exe limitations
set JAVA_OPTS=
set RUN_CONF=
set "RUN_CONF_PROFILE=%SVCPATH%\..\server\%SVCPROFILE%\conf\run.conf.bat"
set "RUN_CONF_BIN=%SVCPATH%\run.conf.bat"
if exist "%RUN_CONF_PROFILE%" (
   call "%RUN_CONF_PROFILE%" %*
) else (
  if exist "%RUN_CONF_BIN%" (
    call "%RUN_CONF_BIN%" %*
  ) else (
    echo "No run.conf.bat found" >> run.log
  )
)

REM Suppress killing service on logoff event
if "x%JAVA_OPTS%" == "x" (
  set "JAVA_OPTS=-Xrs"
) else (
  set "JAVA_OPTS=-Xrs %JAVA_OPTS%"
)

echo Y > .r.lock
jbosssvc.exe -p 1 "Starting %SVCDISP%" >> run.log
call "%SVCPATH%\run.bat" -c %SVCPROFILE% -b %SVCBINDIP% < .r.lock >> run.log 2>&1
jbosssvc.exe -p 1 "Shutdown %SVCDISP% service" >> run.log
del .r.lock
goto cmdEnd

:cmdStop
REM Executed on service stop
echo Y > .s.lock
jbosssvc.exe -p 1 "Shutting down %SVCDISP%" > shutdown.log
call "%SVCPATH%\shutdown.bat" -S < .s.lock >> shutdown.log 2>&1
jbosssvc.exe -p 1 "Shutdown %SVCDISP% service" >> shutdown.log
del .s.lock
goto cmdEnd

:cmdRestart
REM Executed manually from command line
REM Note: We can only stop and start
echo Y > .s.lock
jbosssvc.exe -p 1 "Shutting down %SVCDISP%" >> shutdown.log
call "%SVCPATH%\shutdown.bat" -S < .s.lock >> shutdown.log 2>&1
del .s.lock
goto cmdStart

:cmdSignal
REM Send signal to the service.
REM Requires jbosssch.dll to be loaded in JVM
@if not ""%2"" == """" goto execSignal
echo Missing signal parameter.
echo Usage: service signal [0...9]
goto cmdEnd
:execSignal
jbosssvc.exe -k%2 %SVCNAME%
goto cmdEnd

:cmdEnd

