/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.ConfigurationProperties;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.MetadataResolver;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.impl.RepositoryEventDispatcher;
import org.sonatype.aether.impl.UpdateCheck;
import org.sonatype.aether.impl.UpdateCheckManager;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.LocalMetadataRegistration;
import org.sonatype.aether.repository.LocalMetadataRequest;
import org.sonatype.aether.repository.LocalMetadataResult;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.MetadataRequest;
import org.sonatype.aether.resolution.MetadataResult;
import org.sonatype.aether.spi.connector.MetadataDownload;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.transfer.MetadataNotFoundException;
import org.sonatype.aether.transfer.MetadataTransferException;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;
import org.sonatype.aether.util.listener.DefaultRepositoryEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MetadataResolver.class)
public class DefaultMetadataResolver
implements MetadataResolver,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement
    private UpdateCheckManager updateCheckManager;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;

    public DefaultMetadataResolver() {
    }

    public DefaultMetadataResolver(Logger logger, RepositoryEventDispatcher repositoryEventDispatcher, UpdateCheckManager updateCheckManager, RemoteRepositoryManager remoteRepositoryManager) {
        this.setLogger(logger);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
        this.setRepositoryEventDispatcher((RepositoryEventDispatcher)locator.getService(RepositoryEventDispatcher.class));
        this.setUpdateCheckManager((UpdateCheckManager)locator.getService(UpdateCheckManager.class));
        this.setRemoteRepositoryManager((RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class));
    }

    public DefaultMetadataResolver setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultMetadataResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultMetadataResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        if (updateCheckManager == null) {
            throw new IllegalArgumentException("update check manager has not been specified");
        }
        this.updateCheckManager = updateCheckManager;
        return this;
    }

    public DefaultMetadataResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        ArrayList<MetadataResult> results = new ArrayList<MetadataResult>(requests.size());
        ArrayList<ResolveTask> tasks = new ArrayList<ResolveTask>(requests.size());
        CountDownLatch latch = new CountDownLatch(requests.size());
        HashMap<File, Long> localLastUpdates = new HashMap<File, Long>();
        for (MetadataRequest metadataRequest : requests) {
            File localFile;
            MetadataResult result = new MetadataResult(metadataRequest);
            results.add(result);
            Metadata metadata = metadataRequest.getMetadata();
            RemoteRepository repository = metadataRequest.getRepository();
            if (repository == null) {
                LocalRepository localRepo = session.getLocalRepositoryManager().getRepository();
                this.metadataResolving(session, metadata, (ArtifactRepository)localRepo);
                File localFile2 = this.getLocalFile(session, metadata);
                if (localFile2 != null) {
                    metadata = metadata.setFile(localFile2);
                    result.setMetadata(metadata);
                } else {
                    result.setException((Exception)new MetadataNotFoundException(metadata, localRepo));
                }
                this.metadataResolved(session, metadata, (ArtifactRepository)localRepo, result.getException());
                continue;
            }
            List<RemoteRepository> repositories = this.getEnabledSourceRepositories(repository, metadata.getNature());
            if (repositories.isEmpty()) continue;
            this.metadataResolving(session, metadata, (ArtifactRepository)repository);
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            LocalMetadataRequest localRequest = new LocalMetadataRequest(metadata, repository, metadataRequest.getRequestContext());
            LocalMetadataResult lrmResult = lrm.find(session, localRequest);
            File metadataFile = lrmResult.getFile();
            if (session.isOffline()) {
                if (metadataFile != null) {
                    metadata = metadata.setFile(metadataFile);
                    result.setMetadata(metadata);
                    this.metadataResolved(session, metadata, (ArtifactRepository)repository, null);
                    continue;
                }
                String msg = "The repository system is offline but the metadata " + metadata + " from " + repository + " is not available in the local repository.";
                result.setException((Exception)new MetadataNotFoundException(metadata, repository, msg));
                this.metadataResolved(session, metadata, (ArtifactRepository)repository, result.getException());
                continue;
            }
            Long localLastUpdate = null;
            if (metadataRequest.isFavorLocalRepository() && (localLastUpdate = (Long)localLastUpdates.get(localFile = this.getLocalFile(session, metadata))) == null) {
                localLastUpdate = localFile != null ? localFile.lastModified() : 0L;
                localLastUpdates.put(localFile, localLastUpdate);
            }
            ArrayList<UpdateCheck<Metadata, MetadataTransferException>> checks = new ArrayList<UpdateCheck<Metadata, MetadataTransferException>>();
            MetadataTransferException exception = null;
            for (RemoteRepository repo : repositories) {
                UpdateCheck<Metadata, MetadataTransferException> check = new UpdateCheck<Metadata, MetadataTransferException>();
                check.setLocalLastUpdated(localLastUpdate != null ? localLastUpdate : 0L);
                check.setItem(metadata);
                File checkFile = new File(session.getLocalRepository().getBasedir(), session.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, repository, metadataRequest.getRequestContext()));
                check.setFile(checkFile);
                check.setRepository(repository);
                check.setAuthoritativeRepository(repo);
                check.setPolicy(this.getPolicy(session, repo, metadata.getNature()).getUpdatePolicy());
                if (lrmResult.isStale()) {
                    checks.add(check);
                    continue;
                }
                this.updateCheckManager.checkMetadata(session, check);
                if (check.isRequired()) {
                    checks.add(check);
                    continue;
                }
                if (exception != null) continue;
                exception = check.getException();
            }
            if (!checks.isEmpty()) {
                RepositoryPolicy policy = this.getPolicy(session, repository, metadata.getNature());
                File installFile = new File(session.getLocalRepository().getBasedir(), session.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, metadataRequest.getRepository(), metadataRequest.getRequestContext()));
                ResolveTask task = new ResolveTask(session, result, installFile, checks, policy.getChecksumPolicy(), latch);
                tasks.add(task);
                continue;
            }
            result.setException(exception);
            if (metadataFile != null) {
                metadata = metadata.setFile(metadataFile);
                result.setMetadata(metadata);
            }
            this.metadataResolved(session, metadata, (ArtifactRepository)repository, result.getException());
        }
        if (!tasks.isEmpty()) {
            int threads = ConfigurationProperties.get((RepositorySystemSession)session, (String)"aether.metadataResolver.threads", (int)4);
            Executor executor = this.getExecutor(Math.min(tasks.size(), threads));
            try {
                while (latch.getCount() > (long)tasks.size()) {
                    latch.countDown();
                }
                for (ResolveTask task : tasks) {
                    executor.execute(task);
                }
                latch.await();
                for (ResolveTask task : tasks) {
                    task.result.setException((Exception)task.exception);
                }
            }
            catch (InterruptedException e) {
                for (ResolveTask task : tasks) {
                    MetadataResult result = task.result;
                    result.setException((Exception)new MetadataTransferException(result.getRequest().getMetadata(), result.getRequest().getRepository(), (Throwable)e));
                }
            }
            finally {
                this.shutdown(executor);
            }
            for (ResolveTask task : tasks) {
                Metadata metadata = task.request.getMetadata();
                LocalMetadataRequest localRequest = new LocalMetadataRequest(metadata, task.request.getRepository(), task.request.getRequestContext());
                File metadataFile = session.getLocalRepositoryManager().find(session, localRequest).getFile();
                if (metadataFile != null) {
                    metadata = metadata.setFile(metadataFile);
                    task.result.setMetadata(metadata);
                }
                if (task.result.getException() == null) {
                    task.result.setUpdated(true);
                }
                this.metadataResolved(session, metadata, (ArtifactRepository)task.request.getRepository(), task.result.getException());
            }
        }
        return results;
    }

    private File getLocalFile(RepositorySystemSession session, Metadata metadata) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        LocalMetadataResult localResult = lrm.find(session, new LocalMetadataRequest(metadata, null, null));
        File localFile = localResult.getFile();
        return localFile;
    }

    private List<RemoteRepository> getEnabledSourceRepositories(RemoteRepository repository, Metadata.Nature nature) {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        if (repository.isRepositoryManager()) {
            for (RemoteRepository repo : repository.getMirroredRepositories()) {
                if (!this.isEnabled(repo, nature)) continue;
                repositories.add(repo);
            }
        } else if (this.isEnabled(repository, nature)) {
            repositories.add(repository);
        }
        return repositories;
    }

    private boolean isEnabled(RemoteRepository repository, Metadata.Nature nature) {
        if (!Metadata.Nature.SNAPSHOT.equals((Object)nature) && repository.getPolicy(false).isEnabled()) {
            return true;
        }
        return !Metadata.Nature.RELEASE.equals((Object)nature) && repository.getPolicy(true).isEnabled();
    }

    private RepositoryPolicy getPolicy(RepositorySystemSession session, RemoteRepository repository, Metadata.Nature nature) {
        boolean releases = !Metadata.Nature.SNAPSHOT.equals((Object)nature);
        boolean snapshots = !Metadata.Nature.RELEASE.equals((Object)nature);
        return this.remoteRepositoryManager.getPolicy(session, repository, releases, snapshots);
    }

    private void metadataResolving(RepositorySystemSession session, Metadata metadata, ArtifactRepository repository) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_RESOLVING, session);
        event.setMetadata(metadata);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }

    private void metadataResolved(RepositorySystemSession session, Metadata metadata, ArtifactRepository repository, Exception exception) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_RESOLVED, session);
        event.setMetadata(metadata);
        event.setRepository(repository);
        event.setException(exception);
        event.setFile(metadata.getFile());
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }

    private void metadataDownloading(RepositorySystemSession session, Metadata metadata, ArtifactRepository repository) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_DOWNLOADING, session);
        event.setMetadata(metadata);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }

    private void metadataDownloaded(RepositorySystemSession session, Metadata metadata, ArtifactRepository repository, File file, Exception exception) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_DOWNLOADED, session);
        event.setMetadata(metadata);
        event.setRepository(repository);
        event.setException(exception);
        event.setFile(file);
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }

    private Executor getExecutor(int threads) {
        if (threads <= 1) {
            return new Executor(){

                public void execute(Runnable command) {
                    command.run();
                }
            };
        }
        return new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    private void shutdown(Executor executor) {
        if (executor instanceof ExecutorService) {
            ((ExecutorService)executor).shutdown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResolveTask
    implements Runnable {
        final RepositorySystemSession session;
        final MetadataResult result;
        final MetadataRequest request;
        final File metadataFile;
        final String policy;
        final List<UpdateCheck<Metadata, MetadataTransferException>> checks;
        final CountDownLatch latch;
        volatile MetadataTransferException exception;

        public ResolveTask(RepositorySystemSession session, MetadataResult result, File metadataFile, List<UpdateCheck<Metadata, MetadataTransferException>> checks, String policy, CountDownLatch latch) {
            this.session = session;
            this.result = result;
            this.request = result.getRequest();
            this.metadataFile = metadataFile;
            this.policy = policy;
            this.checks = checks;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Metadata metadata = this.request.getMetadata();
            RemoteRepository requestRepository = this.request.getRepository();
            DefaultMetadataResolver.this.metadataDownloading(this.session, metadata, (ArtifactRepository)requestRepository);
            try {
                ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
                for (UpdateCheck<Metadata, MetadataTransferException> check : this.checks) {
                    repositories.add(check.getAuthoritativeRepository());
                }
                MetadataDownload download = new MetadataDownload();
                download.setMetadata(metadata);
                download.setRequestContext(this.request.getRequestContext());
                download.setFile(this.metadataFile);
                download.setChecksumPolicy(this.policy);
                download.setRepositories(repositories);
                RepositoryConnector connector = DefaultMetadataResolver.this.remoteRepositoryManager.getRepositoryConnector(this.session, requestRepository);
                try {
                    connector.get(null, Arrays.asList(download));
                }
                finally {
                    connector.close();
                }
                this.exception = download.getException();
                if (this.exception == null) {
                    List<String> contexts = Collections.singletonList(this.request.getRequestContext());
                    LocalMetadataRegistration registration = new LocalMetadataRegistration(metadata, requestRepository, contexts);
                    this.session.getLocalRepositoryManager().add(this.session, registration);
                } else if (this.request.isDeleteLocalCopyIfMissing() && this.exception instanceof MetadataNotFoundException) {
                    download.getFile().delete();
                }
            }
            catch (NoRepositoryConnectorException e) {
                this.exception = new MetadataTransferException(metadata, requestRepository, (Throwable)e);
            }
            finally {
                this.latch.countDown();
            }
            for (UpdateCheck<Metadata, MetadataTransferException> check : this.checks) {
                DefaultMetadataResolver.this.updateCheckManager.touchMetadata(this.session, check.setException(this.exception));
            }
            DefaultMetadataResolver.this.metadataDownloaded(this.session, metadata, (ArtifactRepository)requestRepository, this.metadataFile, (Exception)this.exception);
        }
    }
}

