/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.locators;

import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Set;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.sonatype.guice.bean.locators.QualifiedBean;
import org.sonatype.guice.plexus.locators.ClassRealmUtils;
import org.sonatype.guice.plexus.locators.GlobalPlexusBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RealmPlexusBeans<T>
extends GlobalPlexusBeans<T> {
    private ClassRealm cachedContextRealm;

    RealmPlexusBeans(TypeLiteral<T> role, String ... hints) {
        super(role, hints);
    }

    @Override
    protected boolean refreshCache() {
        ClassRealm contextRealm = ClassRealmUtils.contextRealm();
        if (contextRealm == this.cachedContextRealm) {
            return false;
        }
        this.cachedContextRealm = contextRealm;
        return true;
    }

    @Override
    protected Iterable<QualifiedBean<Named, T>> getVisibleBeans() {
        return this.getVisibleBeans(this.cachedContextRealm);
    }

    private Iterable<QualifiedBean<Named, T>> getVisibleBeans(ClassRealm contextRealm) {
        Set<String> visibleRealmNames = ClassRealmUtils.visibleRealmNames(contextRealm);
        if (visibleRealmNames.isEmpty()) {
            return this.beans;
        }
        ArrayList<QualifiedBean<Named, T>> visibleBeans = new ArrayList<QualifiedBean<Named, T>>();
        for (QualifiedBean bean : this.beans) {
            String source = bean.getBinding().getSource().toString();
            if (source.startsWith("ClassRealm") && !visibleRealmNames.contains(source)) continue;
            visibleBeans.add(bean);
        }
        return visibleBeans;
    }
}

