# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
dnl We require 2.13 because we rely on SHELL being computed by configure.
AC_PREREQ([2.13])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
dnl Set install_sh for make dist
install_sh="$missing_dir/install-sh"
test -f "$install_sh" || install_sh="$missing_dir/install.sh"
AC_SUBST(install_sh)
dnl We check for tar when the user configures the end package.
dnl This is sad, since we only need this for "dist".  However,
dnl there's no other good way to do it.  We prefer GNU tar if
dnl we can find it.  If we can't find a tar, it doesn't really matter.
AC_CHECK_PROGS(AMTAR, gnutar gtar tar)
dnl We need awk for the "check" target.  The system "awk" is bad on
dnl some platforms.
AC_REQUIRE([AC_PROG_AWK])
AMTARFLAGS=
if test -n "$AMTAR"; then
  if $SHELL -c "$AMTAR --version" > /dev/null 2>&1; then
    dnl We have GNU tar.
    AMTARFLAGS=o
  fi
fi
AC_SUBST(AMTARFLAGS)
AC_REQUIRE([AC_PROG_MAKE_SET])])
