/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.domain.management.security.password;
import static org.jboss.as.domain.management.DomainManagementMessages.MESSAGES;
/**
 * @author baranowb
 *
 */
public class LengthRestriction extends PasswordRestriction {

    private final int desiredLength;

    /**
     * @param desiredLength
     */
    public LengthRestriction(int desiredLength) {
        super(MESSAGES.passwordNotLongEnough(desiredLength));
        this.desiredLength = desiredLength;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.jboss.as.domain.management.security.password.PasswordRestriction#pass(java.lang.String)
     */
    @Override
    public boolean pass(String password) {
        if (password == null || password.length() < this.desiredLength) {
            return false;
        } else {
            return true;
        }
    }
}
