/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.integration.jaxrs.provider.stream;

import java.io.UnsupportedEncodingException;
import java.net.URL;

import junit.framework.Assert;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.test.integration.jaxrs.packaging.war.WebXml;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * @author baranowb
 * 
 */
@RunWith(Arquillian.class)
@RunAsClient
public class DataSourceTestCase {
    public static final String DEPLOYMENT_NAME = "datasource";
    public static final String DEPLOYMENT = DEPLOYMENT_NAME + ".war";

    @ArquillianResource
    private URL baseURLNoAuth;
    private HttpClient httpClient;

    @Deployment()
    public static Archive<?> deploy() {
        WebArchive war = ShrinkWrap.create(WebArchive.class, DEPLOYMENT);
        war.add(EmptyAsset.INSTANCE, "WEB-INF/beans.xml");
        war.addClasses(RestConsumer.class);
        war.addAsWebInfResource(WebXml.get("<servlet-mapping>\n"
                + "        <servlet-name>javax.ws.rs.core.Application</servlet-name>\n"
                + "        <url-pattern>/myjaxrs/*</url-pattern>\n" + "    </servlet-mapping>\n" + "\n"), "web.xml");
        return war;
    }

    @Before
    public void setup() {
        this.httpClient = new DefaultHttpClient();
    }

    @After
    public void tearDown() {
        if (httpClient != null) {
            try {
                // shut down the connection manager to ensure
                // immediate deallocation of all system resources
                httpClient.getConnectionManager().shutdown();
            } finally {
                httpClient = null;
            }
        }
    }

    @Test
    public void testDataSourceInputStream() throws Exception {
        final HttpPost request = new HttpPost(baseURLNoAuth.toURI() + "myjaxrs" + RestConsumer.PATH_UPLOAD);
        
        request.setEntity(createContent());
        final HttpResponse response = this.httpClient.execute(request);
        final StringBuilder msg = new StringBuilder();
        msg.append(response.getStatusLine().toString());
        final HttpEntity entity = response.getEntity();
        if(entity!=null){
            msg.append("\n").append(EntityUtils.toString(entity));
        }
        Assert.assertEquals(msg.toString(), 200, response.getStatusLine().getStatusCode());
    }

    private StringEntity createContent() throws UnsupportedEncodingException{
        StringBuilder stringBuilder = new StringBuilder();
        for(int i=0;i<2500;i++){
            stringBuilder.append(i).append(":\n");
        }
        return new StringEntity(stringBuilder.toString());
    }
}
