package org.jboss.as.cli.impl;

import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.scriptsupport.CLI;
import org.junit.Ignore;
import org.junit.Test;

/**
 * Demonstrates BZ-1232736 memory leak in CLI
 *
 * Instructions:
 *
 * 1) run standalone EAP on default ports
 * 2) un-ignore this test
 * 3) go to $EAP_HOME/cli/
 * 4) run the test with `MAVEN_OPTS="-Xmx64m -XX:+HeapDumpOnOutOfMemoryError" mvn test -Dtest=CommandContextImplTestCase -DforkMode=never`
 *
 * With broken version, test should fail with 'Exception in provider: Java heap space' message before reaching
 * 10000 iterations. Fixed version should complete successfully.
 *
 * @author Tomas Hofman (thofman@redhat.com)
 */
@Ignore // demonstration only, not to be run during build process
public class CommandContextImplTestCase {

    @Test
    public void testCommandContext() throws CliInitializationException {
        CLI cli = CLI.newInstance();
        for (int i = 0; i < 10000; i++) {
            cli.connect();
            cli.disconnect();
            System.out.println(i);
        }
    }

}
