/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FacesMessage
implements Serializable {
    public static final String FACES_MESSAGES = "javax.faces.Messages";
    private static final String SEVERITY_INFO_NAME = "INFO";
    public static final Severity SEVERITY_INFO = new Severity("INFO");
    private static final String SEVERITY_WARN_NAME = "WARN";
    public static final Severity SEVERITY_WARN = new Severity("WARN");
    private static final String SEVERITY_ERROR_NAME = "ERROR";
    public static final Severity SEVERITY_ERROR = new Severity("ERROR");
    private static final String SEVERITY_FATAL_NAME = "FATAL";
    public static final Severity SEVERITY_FATAL = new Severity("FATAL");
    private static final Severity[] values = new Severity[]{SEVERITY_INFO, SEVERITY_WARN, SEVERITY_ERROR, SEVERITY_FATAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private static Map<String, Severity> _MODIFIABLE_MAP = new HashMap<String, Severity>(4, 1.0f);
    public static final Map VALUES_MAP;
    private static final long serialVersionUID = -1180773928220076822L;
    private Severity severity = SEVERITY_INFO;
    private String summary = null;
    private String detail = null;

    public FacesMessage() {
    }

    public FacesMessage(String string) {
        this.setSummary(string);
    }

    public FacesMessage(String string, String string2) {
        this.setSummary(string);
        this.setDetail(string2);
    }

    public FacesMessage(Severity severity, String string, String string2) {
        this.setSeverity(severity);
        this.setSummary(string);
        this.setDetail(string2);
    }

    public String getDetail() {
        if (this.detail == null) {
            return this.summary;
        }
        return this.detail;
    }

    public void setDetail(String string) {
        this.detail = string;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        if (severity.getOrdinal() < SEVERITY_INFO.getOrdinal() || severity.getOrdinal() > SEVERITY_FATAL.getOrdinal()) {
            throw new IllegalArgumentException(String.valueOf(severity));
        }
        this.severity = severity;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String string) {
        this.summary = string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.getSeverity().getOrdinal());
        objectOutputStream.writeObject(this.getSummary());
        objectOutputStream.writeObject(this.getDetail());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.severity = SEVERITY_INFO;
        this.summary = null;
        this.detail = null;
        int n = objectInputStream.readInt();
        if (n == SEVERITY_INFO.getOrdinal()) {
            this.setSeverity(SEVERITY_INFO);
        } else if (n == SEVERITY_WARN.getOrdinal()) {
            this.setSeverity(SEVERITY_WARN);
        } else if (n == SEVERITY_ERROR.getOrdinal()) {
            this.setSeverity(SEVERITY_ERROR);
        } else if (n == SEVERITY_FATAL.getOrdinal()) {
            this.setSeverity(SEVERITY_FATAL);
        }
        this.setSummary((String)objectInputStream.readObject());
        this.setDetail((String)objectInputStream.readObject());
    }

    static {
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            _MODIFIABLE_MAP.put(FacesMessage.values[i].severityName, values[i]);
        }
        VALUES_MAP = Collections.unmodifiableMap(_MODIFIABLE_MAP);
    }

    public static class Severity
    implements Comparable {
        private final int ordinal = nextOrdinal++;
        String severityName = null;
        private static int nextOrdinal = 0;

        private Severity(String string) {
            this.severityName = string;
        }

        public int compareTo(Object object) {
            return this.ordinal - ((Severity)object).ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String toString() {
            if (null == this.severityName) {
                return String.valueOf(this.ordinal);
            }
            return String.valueOf(this.severityName) + ' ' + this.ordinal;
        }
    }
}

