/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public abstract class ViewHandler {
    private static Logger log = Logger.getLogger("javax.faces.application");
    public static final String CHARACTER_ENCODING_KEY = "javax.faces.request.charset";
    public static final String DEFAULT_SUFFIX_PARAM_NAME = "javax.faces.DEFAULT_SUFFIX";
    public static final String DEFAULT_SUFFIX = ".jsp";

    public abstract Locale calculateLocale(FacesContext var1);

    public String calculateCharacterEncoding(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map<String, String> map = externalContext.getRequestHeaderMap();
        String string = map.get("Content-Type");
        String string2 = null;
        if (null != string) {
            String string3 = "charset=";
            int n = string3.length();
            int n2 = string.indexOf(string3);
            if (n2 != -1 && n2 + n < string.length()) {
                string2 = string.substring(n2 + n);
            }
        }
        if (null == string2 && null != externalContext.getSession(false)) {
            string2 = (String)externalContext.getSessionMap().get(CHARACTER_ENCODING_KEY);
        }
        return string2;
    }

    public abstract String calculateRenderKitId(FacesContext var1);

    public abstract UIViewRoot createView(FacesContext var1, String var2);

    public abstract String getActionURL(FacesContext var1, String var2);

    public abstract String getResourceURL(FacesContext var1, String var2);

    public void initView(FacesContext facesContext) throws FacesException {
        String string = this.calculateCharacterEncoding(facesContext);
        if (null != string) {
            try {
                facesContext.getExternalContext().setRequestCharacterEncoding(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string2 = "Can't set encoding to: " + string + " Exception:" + unsupportedEncodingException.getMessage();
                if (log.isLoggable(Level.WARNING)) {
                    log.fine(string2);
                }
                throw new FacesException(string2, unsupportedEncodingException);
            }
        }
    }

    public abstract void renderView(FacesContext var1, UIViewRoot var2) throws IOException, FacesException;

    public abstract UIViewRoot restoreView(FacesContext var1, String var2);

    public abstract void writeState(FacesContext var1) throws IOException;
}

