/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SelectItemsIterator
implements Iterator<SelectItem> {
    private Iterator<SelectItem> items = null;
    private ListIterator<UIComponent> kids = null;

    public SelectItemsIterator(UIComponent uIComponent) {
        this.kids = uIComponent.getChildren().listIterator();
    }

    @Override
    public boolean hasNext() {
        Object object;
        if (this.items != null) {
            if (this.items.hasNext()) {
                return true;
            }
            this.items = null;
        }
        if ((object = this.findNextValidChild()) != null) {
            this.kids.previous();
            return true;
        }
        return false;
    }

    @Override
    public SelectItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.items != null) {
            return this.items.next();
        }
        UIComponent uIComponent = (UIComponent)this.findNextValidChild();
        if (uIComponent instanceof UISelectItem) {
            UISelectItem uISelectItem = (UISelectItem)uIComponent;
            SelectItem selectItem = (SelectItem)uISelectItem.getValue();
            if (selectItem == null) {
                selectItem = new SelectItem(uISelectItem.getItemValue(), uISelectItem.getItemLabel(), uISelectItem.getItemDescription(), uISelectItem.isItemDisabled(), uISelectItem.isItemEscaped());
            }
            return selectItem;
        }
        if (uIComponent instanceof UISelectItems) {
            UISelectItems uISelectItems = (UISelectItems)uIComponent;
            Object object = uISelectItems.getValue();
            if (object instanceof SelectItem) {
                return (SelectItem)object;
            }
            if (object instanceof SelectItem[]) {
                this.items = Arrays.asList((SelectItem[])object).iterator();
                return this.next();
            }
            if (object instanceof Collection) {
                this.items = ((Collection)object).iterator();
                return this.next();
            }
            if (object instanceof Map) {
                ArrayList<SelectItem> arrayList = new ArrayList<SelectItem>(((Map)object).size());
                for (Object k : ((Map)object).keySet()) {
                    Object v;
                    if (k == null || (v = ((Map)object).get(k)) == null) continue;
                    arrayList.add(new SelectItem(v, k.toString(), null));
                }
                this.items = arrayList.iterator();
                return this.next();
            }
            throw new IllegalArgumentException();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Object findNextValidChild() {
        if (this.kids.hasNext()) {
            UIComponent uIComponent = this.kids.next();
            while (this.kids.hasNext() && !(uIComponent instanceof UISelectItem) && !(uIComponent instanceof UISelectItems)) {
                uIComponent = this.kids.next();
            }
            if (uIComponent instanceof UISelectItem || uIComponent instanceof UISelectItems) {
                return uIComponent;
            }
        }
        return null;
    }
}

