/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.TypedCollections;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class UIViewRoot
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "j_id";
    private static Lifecycle lifecycle;
    private static final Logger LOGGER;
    private int lastId = 0;
    private boolean skipPhase;
    private boolean beforeMethodException;
    private ListIterator<PhaseListener> phaseListenerIterator;
    private String renderKitId = null;
    private String viewId = null;
    private MethodExpression beforePhase = null;
    private MethodExpression afterPhase = null;
    private List<PhaseListener> phaseListeners = null;
    private List<List<FacesEvent>> events = null;
    private Locale locale = null;
    private Object[] values;

    public UIViewRoot() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    public String getRenderKitId() {
        String string;
        if (null != this.renderKitId) {
            string = this.renderKitId;
        } else {
            ValueExpression valueExpression = this.getValueExpression("renderKitId");
            FacesContext facesContext = this.getFacesContext();
            if (valueExpression != null) {
                try {
                    string = (String)valueExpression.getValue(facesContext.getELContext());
                }
                catch (ELException eLException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{valueExpression.getExpressionString(), "renderKitId"});
                    }
                    string = null;
                }
            } else {
                string = null;
            }
        }
        return string;
    }

    public void setRenderKitId(String string) {
        this.renderKitId = string;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String string) {
        this.viewId = string;
    }

    public MethodExpression getBeforePhaseListener() {
        return this.beforePhase;
    }

    public void setBeforePhaseListener(MethodExpression methodExpression) {
        this.beforePhase = methodExpression;
    }

    public MethodExpression getAfterPhaseListener() {
        return this.afterPhase;
    }

    public void setAfterPhaseListener(MethodExpression methodExpression) {
        this.afterPhase = methodExpression;
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        if (null != this.phaseListeners) {
            this.phaseListeners.remove(phaseListener);
        }
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        if (null == this.phaseListeners) {
            this.phaseListeners = new ArrayList<PhaseListener>();
        }
        this.phaseListeners.add(phaseListener);
    }

    public void queueEvent(FacesEvent facesEvent) {
        if (facesEvent == null) {
            throw new NullPointerException();
        }
        int n = PhaseId.VALUES.size();
        if (this.events == null) {
            ArrayList<List<FacesEvent>> arrayList = new ArrayList<List<FacesEvent>>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new ArrayList(5));
            }
            this.events = arrayList;
        }
        this.events.get(facesEvent.getPhaseId().getOrdinal()).add(facesEvent);
    }

    private void broadcastEvents(FacesContext facesContext, PhaseId phaseId) {
        boolean bl;
        boolean bl2;
        if (null == this.events) {
            return;
        }
        List<FacesEvent> list = this.events.get(PhaseId.ANY_PHASE.getOrdinal());
        do {
            UIComponent uIComponent;
            FacesEvent facesEvent;
            if (null != list) {
                while (!list.isEmpty()) {
                    block11: {
                        facesEvent = list.get(0);
                        uIComponent = facesEvent.getComponent();
                        try {
                            uIComponent.broadcast(facesEvent);
                        }
                        catch (AbortProcessingException abortProcessingException) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                            UIComponent uIComponent2 = facesEvent.getComponent();
                            String string = "";
                            if (uIComponent2 != null && (string = uIComponent2.getId()) == null) {
                                string = uIComponent2.getClientId(facesContext);
                            }
                            LOGGER.log(Level.SEVERE, "error.component.abortprocessing_thrown", new Object[]{facesEvent.getClass().getName(), phaseId.toString(), string});
                            LOGGER.log(Level.SEVERE, abortProcessingException.toString(), abortProcessingException);
                        }
                    }
                    list.remove(0);
                }
            }
            if (null != (list = this.events.get(phaseId.getOrdinal()))) {
                while (!list.isEmpty()) {
                    facesEvent = list.get(0);
                    uIComponent = facesEvent.getComponent();
                    try {
                        uIComponent.broadcast(facesEvent);
                    }
                    catch (AbortProcessingException abortProcessingException) {
                        // empty catch block
                    }
                    list.remove(0);
                }
            }
            bl2 = null != (list = this.events.get(PhaseId.ANY_PHASE.getOrdinal())) && !list.isEmpty();
            boolean bl3 = bl = null != this.events.get(phaseId.getOrdinal()) && !this.events.get(phaseId.getOrdinal()).isEmpty();
        } while (bl2 || bl);
    }

    private void initState() {
        this.skipPhase = false;
        this.beforeMethodException = false;
        this.phaseListenerIterator = this.phaseListeners != null ? this.phaseListeners.listIterator() : null;
    }

    private void notifyBefore(FacesContext facesContext, PhaseId phaseId) {
        if (null != this.beforePhase || null != this.phaseListenerIterator) {
            this.notifyPhaseListeners(facesContext, phaseId, true);
        }
    }

    private void notifyAfter(FacesContext facesContext, PhaseId phaseId) {
        if (null != this.afterPhase || null != this.phaseListenerIterator) {
            this.notifyPhaseListeners(facesContext, phaseId, false);
        }
    }

    public void processDecodes(FacesContext facesContext) {
        this.initState();
        this.notifyBefore(facesContext, PhaseId.APPLY_REQUEST_VALUES);
        if (!this.skipPhase) {
            super.processDecodes(facesContext);
            this.broadcastEvents(facesContext, PhaseId.APPLY_REQUEST_VALUES);
        }
        this.clearFacesEvents(facesContext);
        this.notifyAfter(facesContext, PhaseId.APPLY_REQUEST_VALUES);
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        this.initState();
        this.notifyBefore(facesContext, PhaseId.RENDER_RESPONSE);
        if (!this.skipPhase) {
            super.encodeBegin(facesContext);
        }
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        super.encodeEnd(facesContext);
        this.notifyAfter(facesContext, PhaseId.RENDER_RESPONSE);
    }

    private void notifyPhaseListeners(FacesContext facesContext, PhaseId phaseId, boolean bl) {
        MethodExpression methodExpression;
        PhaseEvent phaseEvent = UIViewRoot.createPhaseEvent(facesContext, phaseId);
        boolean bl2 = bl && null != this.beforePhase || !bl && null != this.afterPhase && !this.beforeMethodException;
        MethodExpression methodExpression2 = methodExpression = bl ? this.beforePhase : this.afterPhase;
        if (bl2) {
            try {
                methodExpression.invoke(facesContext.getELContext(), new Object[]{phaseEvent});
                this.skipPhase = facesContext.getResponseComplete() || facesContext.getRenderResponse();
            }
            catch (Exception exception) {
                if (bl) {
                    this.beforeMethodException = true;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Exception", exception);
                    LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{methodExpression.getExpressionString(), bl ? "beforePhase" : "afterPhase"});
                }
                return;
            }
        }
        if (this.phaseListenerIterator != null && !this.beforeMethodException) {
            while (bl ? this.phaseListenerIterator.hasNext() : this.phaseListenerIterator.hasPrevious()) {
                PhaseListener phaseListener;
                PhaseListener phaseListener2 = phaseListener = bl ? this.phaseListenerIterator.next() : this.phaseListenerIterator.previous();
                if (phaseId != phaseListener.getPhaseId() && PhaseId.ANY_PHASE != phaseListener.getPhaseId()) continue;
                try {
                    if (bl) {
                        phaseListener.beforePhase(phaseEvent);
                    } else {
                        phaseListener.afterPhase(phaseEvent);
                    }
                    this.skipPhase = facesContext.getResponseComplete() || facesContext.getRenderResponse();
                }
                catch (Exception exception) {
                    if (bl && this.phaseListenerIterator.hasPrevious()) {
                        this.phaseListenerIterator.previous();
                    }
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "severe.component.uiviewroot_error_invoking_phaselistener", phaseListener.getClass().getName());
                    }
                    return;
                }
            }
        }
    }

    private static PhaseEvent createPhaseEvent(FacesContext facesContext, PhaseId phaseId) throws FacesException {
        if (lifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String string = facesContext.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
            if (string == null) {
                string = "DEFAULT";
            }
            lifecycle = lifecycleFactory.getLifecycle(string);
        }
        return new PhaseEvent(facesContext, phaseId, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processValidators(FacesContext facesContext) {
        this.initState();
        this.notifyBefore(facesContext, PhaseId.PROCESS_VALIDATIONS);
        try {
            if (!this.skipPhase) {
                super.processValidators(facesContext);
                this.broadcastEvents(facesContext, PhaseId.PROCESS_VALIDATIONS);
            }
        }
        finally {
            this.clearFacesEvents(facesContext);
            this.notifyAfter(facesContext, PhaseId.PROCESS_VALIDATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdates(FacesContext facesContext) {
        this.initState();
        this.notifyBefore(facesContext, PhaseId.UPDATE_MODEL_VALUES);
        try {
            if (!this.skipPhase) {
                super.processUpdates(facesContext);
                this.broadcastEvents(facesContext, PhaseId.UPDATE_MODEL_VALUES);
            }
        }
        finally {
            this.clearFacesEvents(facesContext);
            this.notifyAfter(facesContext, PhaseId.UPDATE_MODEL_VALUES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processApplication(FacesContext facesContext) {
        this.initState();
        this.notifyBefore(facesContext, PhaseId.INVOKE_APPLICATION);
        try {
            if (!this.skipPhase) {
                this.broadcastEvents(facesContext, PhaseId.INVOKE_APPLICATION);
            }
        }
        finally {
            this.clearFacesEvents(facesContext);
            this.notifyAfter(facesContext, PhaseId.INVOKE_APPLICATION);
        }
    }

    private void clearFacesEvents(FacesContext facesContext) {
        if ((facesContext.getRenderResponse() || facesContext.getResponseComplete()) && this.events != null) {
            for (List<FacesEvent> list : this.events) {
                if (list == null) continue;
                list.clear();
            }
            this.events = null;
        }
    }

    public String createUniqueId() {
        return UNIQUE_ID_PREFIX + this.lastId++;
    }

    public Locale getLocale() {
        Locale locale = null;
        if (null != this.locale) {
            locale = this.locale;
        } else {
            ValueExpression valueExpression = this.getValueExpression("locale");
            FacesContext facesContext = this.getFacesContext();
            if (valueExpression != null) {
                Object object;
                block11: {
                    object = null;
                    try {
                        object = valueExpression.getValue(facesContext.getELContext());
                    }
                    catch (ELException eLException) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                        LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{valueExpression.getExpressionString(), "locale"});
                    }
                }
                if (null == object) {
                    locale = facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
                } else if (object instanceof Locale) {
                    locale = (Locale)object;
                } else if (object instanceof String) {
                    locale = UIViewRoot.getLocaleFromString((String)object);
                }
            } else {
                locale = facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
            }
        }
        return locale;
    }

    private static Locale getLocaleFromString(String string) throws IllegalArgumentException {
        if (null == string || string.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + string);
        }
        Locale locale = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        char[] cArray = new char[]{'-', '_'};
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        if (n3 >= 2 && (n = UIViewRoot.indexOfSet(string, cArray, 0)) == -1) {
            if (string.length() != 2) {
                throw new IllegalArgumentException("Illegal locale String: " + string);
            }
            string2 = string.toLowerCase();
        }
        if (n != -1) {
            string2 = string.substring(0, n);
            if (n3 >= 5 && (n2 = UIViewRoot.indexOfSet(string, cArray, n + 1)) == -1) {
                if (n3 != 5) {
                    throw new IllegalArgumentException("Illegal locale String: " + string);
                }
                string3 = string.substring(n + 1);
            }
            if (n2 != -1) {
                string3 = string.substring(n + 1, n2);
                if (n3 >= 8) {
                    string4 = string.substring(n2 + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + string);
                }
            }
        }
        if (string4 != null && string3 != null && string2 != null) {
            locale = new Locale(string2, string3, string4);
        } else if (string2 != null && string3 != null) {
            locale = new Locale(string2, string3);
        } else if (string2 != null) {
            locale = new Locale(string2, "");
        }
        return locale;
    }

    private static int indexOfSet(String string, char[] cArray, int n) {
        int n2 = -1;
        int n3 = string.length();
        for (int i = n; i < n3; ++i) {
            int n4 = cArray.length;
            for (int j = 0; j < n4; ++j) {
                if (string.charAt(i) != cArray[j]) continue;
                n2 = i;
                break;
            }
            if (n2 != -1) break;
        }
        return n2;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        FacesContext.getCurrentInstance().getELContext().setLocale(locale);
    }

    public Object saveState(FacesContext facesContext) {
        if (this.values == null) {
            this.values = new Object[8];
        }
        this.values[0] = super.saveState(facesContext);
        this.values[1] = this.renderKitId;
        this.values[2] = this.viewId;
        this.values[3] = this.locale;
        this.values[4] = this.lastId;
        this.values[5] = UIViewRoot.saveAttachedState(facesContext, this.beforePhase);
        this.values[6] = UIViewRoot.saveAttachedState(facesContext, this.afterPhase);
        this.values[7] = UIViewRoot.saveAttachedState(facesContext, this.phaseListeners);
        return this.values;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        this.values = (Object[])object;
        super.restoreState(facesContext, this.values[0]);
        this.renderKitId = (String)this.values[1];
        this.viewId = (String)this.values[2];
        this.locale = (Locale)this.values[3];
        this.lastId = (Integer)this.values[4];
        this.beforePhase = (MethodExpression)UIViewRoot.restoreAttachedState(facesContext, this.values[5]);
        this.afterPhase = (MethodExpression)UIViewRoot.restoreAttachedState(facesContext, this.values[6]);
        this.phaseListeners = TypedCollections.dynamicallyCastList((List)UIViewRoot.restoreAttachedState(facesContext, this.values[7]), PhaseListener.class);
    }

    static {
        LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
    }
}

