/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

class MessageFactory {
    private static final String MOJARRA_RESOURCE_BASENAME = "com.sun.faces.resources.Messages";

    private MessageFactory() {
    }

    static FacesMessage getMessage(String string, FacesMessage.Severity severity, Object ... objectArray) {
        FacesMessage facesMessage = MessageFactory.getMessage(string, objectArray);
        facesMessage.setSeverity(severity);
        return facesMessage;
    }

    static FacesMessage getMessage(Locale locale, String string, FacesMessage.Severity severity, Object ... objectArray) {
        FacesMessage facesMessage = MessageFactory.getMessage(locale, string, objectArray);
        facesMessage.setSeverity(severity);
        return facesMessage;
    }

    static FacesMessage getMessage(FacesContext facesContext, String string, FacesMessage.Severity severity, Object ... objectArray) {
        FacesMessage facesMessage = MessageFactory.getMessage(facesContext, string, objectArray);
        facesMessage.setSeverity(severity);
        return facesMessage;
    }

    static FacesMessage getMessage(String string, Object ... objectArray) {
        Locale locale = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && facesContext.getViewRoot() != null) {
            locale = facesContext.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return MessageFactory.getMessage(locale, string, objectArray);
    }

    static FacesMessage getMessage(Locale locale, String string, Object ... objectArray) {
        ResourceBundle resourceBundle;
        String string2 = null;
        String string3 = null;
        String string4 = MessageFactory.getApplication().getMessageBundle();
        if (null != string4 && null != (resourceBundle = ResourceBundle.getBundle(string4, locale, MessageFactory.getCurrentLoader(string4)))) {
            try {
                string2 = resourceBundle.getString(string);
                string3 = resourceBundle.getString(string + "_detail");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (null == string2) {
            resourceBundle = ResourceBundle.getBundle("javax.faces.Messages", locale, MessageFactory.getCurrentLoader(string4));
            if (null == resourceBundle) {
                throw new NullPointerException();
            }
            try {
                string2 = resourceBundle.getString(string);
                string3 = resourceBundle.getString(string + "_detail");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            resourceBundle = ResourceBundle.getBundle(MOJARRA_RESOURCE_BASENAME, locale, MessageFactory.getCurrentLoader(string4));
            if (null == resourceBundle) {
                throw new NullPointerException();
            }
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
        BindingFacesMessage bindingFacesMessage = new BindingFacesMessage(locale, string2, string3, objectArray);
        bindingFacesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
        return bindingFacesMessage;
    }

    static FacesMessage getMessage(FacesContext facesContext, String string, Object ... objectArray) {
        if (facesContext == null || string == null) {
            throw new NullPointerException(" context " + facesContext + " messageId " + string);
        }
        Locale locale = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getLocale() : Locale.getDefault();
        if (null == locale) {
            throw new NullPointerException(" locale is null ");
        }
        FacesMessage facesMessage = MessageFactory.getMessage(locale, string, objectArray);
        if (facesMessage != null) {
            return facesMessage;
        }
        locale = Locale.getDefault();
        return MessageFactory.getMessage(locale, string, objectArray);
    }

    static Object getLabel(FacesContext facesContext, UIComponent uIComponent) {
        Object object = uIComponent.getAttributes().get("label");
        if (object == null || object instanceof String && ((String)object).length() == 0) {
            object = uIComponent.getValueExpression("label");
        }
        if (object == null) {
            object = uIComponent.getClientId(facesContext);
        }
        return object;
    }

    protected static Application getApplication() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return FacesContext.getCurrentInstance().getApplication();
        }
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        return applicationFactory.getApplication();
    }

    protected static ClassLoader getCurrentLoader(Object object) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = object.getClass().getClassLoader();
        }
        return classLoader;
    }

    static class BindingFacesMessage
    extends FacesMessage {
        private Locale locale;
        private Object[] parameters;
        private Object[] resolvedParameters;

        BindingFacesMessage(Locale locale, String string, String string2, Object[] objectArray) {
            super(string, string2);
            this.locale = locale;
            this.parameters = objectArray;
            if (objectArray != null) {
                this.resolvedParameters = new Object[objectArray.length];
            }
        }

        public String getSummary() {
            String string = super.getSummary();
            this.resolveBindings();
            return this.getFormattedString(string, this.resolvedParameters);
        }

        public String getDetail() {
            String string = super.getDetail();
            this.resolveBindings();
            return this.getFormattedString(string, this.resolvedParameters);
        }

        private void resolveBindings() {
            FacesContext facesContext = null;
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    Object object = this.parameters[i];
                    if (object instanceof ValueBinding) {
                        if (facesContext == null) {
                            facesContext = FacesContext.getCurrentInstance();
                        }
                        object = ((ValueBinding)object).getValue(facesContext);
                    }
                    if (object instanceof ValueExpression) {
                        if (facesContext == null) {
                            facesContext = FacesContext.getCurrentInstance();
                        }
                        object = ((ValueExpression)object).getValue(facesContext.getELContext());
                    }
                    if (object == null) {
                        object = "";
                    }
                    this.resolvedParameters[i] = object;
                }
            }
        }

        private String getFormattedString(String string, Object[] objectArray) {
            String string2 = null;
            if (objectArray == null || string == null) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(100);
            MessageFormat messageFormat = new MessageFormat(string);
            if (this.locale != null) {
                messageFormat.setLocale(this.locale);
                stringBuffer.append(messageFormat.format(objectArray));
                string2 = stringBuffer.toString();
            }
            return string2;
        }
    }
}

