/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.FacesLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.servlet.ServletOutputStream;

class ByteArrayWebOutputStream
extends ServletOutputStream {
    public static final ServletOutputStream NOOP_STREAM = new NoOpOutputStream();
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private DirectByteArrayOutputStream baos = new DirectByteArrayOutputStream(1024);
    private boolean committed;

    public void write(int n) {
        this.baos.write(n);
    }

    public void resetByteArray() {
        this.baos.reset();
    }

    public byte[] toByteArray() {
        return this.baos.toByteArray();
    }

    public void writeTo(Writer writer, String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Converting buffered ServletOutputStream bytes to chars using " + string);
        }
        ByteBuffer byteBuffer = this.baos.getByteBuffer();
        CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
        try {
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            writer.write(charBuffer.array());
        }
        catch (CharacterCodingException characterCodingException) {
            throw new FacesException((Throwable)characterCodingException);
        }
        catch (IOException iOException) {
            throw new FacesException((Throwable)iOException);
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void close() throws IOException {
        this.committed = true;
    }

    public void flush() throws IOException {
        this.committed = true;
    }

    public void writeTo(OutputStream outputStream) {
        try {
            outputStream.write(this.baos.getByteBuffer().array());
        }
        catch (IOException iOException) {
            throw new FacesException((Throwable)iOException);
        }
    }

    private static class NoOpOutputStream
    extends ServletOutputStream {
        public void write(int n) throws IOException {
        }

        public void write(byte[] byArray) throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        protected NoOpOutputStream() {
        }

        public void print(String string) throws IOException {
        }

        public void print(boolean bl) throws IOException {
        }

        public void print(char c) throws IOException {
        }

        public void print(int n) throws IOException {
        }

        public void print(long l) throws IOException {
        }

        public void print(float f) throws IOException {
        }

        public void print(double d) throws IOException {
        }

        public void println() throws IOException {
        }

        public void println(String string) throws IOException {
        }

        public void println(boolean bl) throws IOException {
        }

        public void println(char c) throws IOException {
        }

        public void println(int n) throws IOException {
        }

        public void println(long l) throws IOException {
        }

        public void println(float f) throws IOException {
        }

        public void println(double d) throws IOException {
        }
    }

    private static class DirectByteArrayOutputStream
    extends ByteArrayOutputStream {
        public DirectByteArrayOutputStream(int n) {
            super(n);
        }

        public ByteBuffer getByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }
    }
}

