/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.WebappLifecycleListener;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.el.ChainTypeCompositeELResolver;
import com.sun.faces.el.ELContextListenerImpl;
import com.sun.faces.el.ELUtils;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.mgbean.BeanBuilder;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.scripting.GroovyHelper;
import com.sun.faces.scripting.GroovyHelperFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigureListener
implements ServletRequestListener,
HttpSessionListener,
ServletRequestAttributeListener,
HttpSessionAttributeListener,
ServletContextAttributeListener,
ServletContextListener {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private ScheduledThreadPoolExecutor webResourcePool;
    protected WebappLifecycleListener webAppListener;
    protected WebConfiguration webConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Object object;
        ServletContext servletContext = servletContextEvent.getServletContext();
        this.webAppListener = new WebappLifecycleListener(servletContext);
        this.webAppListener.contextInitialized(servletContextEvent);
        Timer timer = Timer.getInstance();
        if (timer != null) {
            timer.startTiming();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, MessageFormat.format("ConfigureListener.contextInitialized({0})", ConfigureListener.getServletContextIdentifier(servletContext)));
        }
        this.webConfig = WebConfiguration.getInstance(servletContext);
        ConfigManager configManager = ConfigManager.getInstance();
        if (configManager.hasBeenInitialized(servletContext)) {
            return;
        }
        if (!this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ForceLoadFacesConfigFiles)) {
            object = new WebXmlProcessor(servletContext);
            if (!((WebXmlProcessor)object).isFacesServletPresent()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "No FacesServlet found in deployment descriptor - bypassing configuration");
                }
                WebConfiguration.clear(servletContext);
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "FacesServlet found in deployment descriptor - processing configuration.");
            }
        }
        object = new InitFacesContext(servletContext);
        ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
        try {
            Object object2;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "jsf.config.listener.version", ConfigureListener.getServletContextIdentifier(servletContext));
            }
            Util.setHtmlTLVActive(this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableHtmlTagLibraryValidator));
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.VerifyFacesConfigObjects)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("jsf.config.verifyobjects.development_only");
                }
                this.webConfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.EnableLazyBeanValidation, false);
                Verifier.setCurrentInstance(new Verifier());
            }
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading)) {
                this.initScripting();
            }
            configManager.initialize(servletContext);
            this.initConfigMonitoring(servletContext);
            Verifier verifier = Verifier.getCurrentInstance();
            if (verifier != null && !verifier.isApplicationValid() && LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("jsf.config.verifyobjects.failures_detected");
                object2 = new StringBuilder(128);
                for (String string : verifier.getMessages()) {
                    ((StringBuilder)object2).append(string).append('\n');
                }
                LOGGER.severe(((StringBuilder)object2).toString());
            }
            this.registerELResolverAndListenerWithJsp(servletContext, false);
            object2 = ApplicationAssociate.getInstance(servletContext);
            if (object2 != null) {
                ((ApplicationAssociate)object2).setContextName(ConfigureListener.getServletContextIdentifier(servletContext));
            }
            RenderKitUtils.loadSunJsfJs(object.getExternalContext());
        }
        finally {
            Verifier.setCurrentInstance(null);
            object.release();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.config.listener.version.complete");
            }
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Initialization of context " + ConfigureListener.getServletContextIdentifier(servletContext));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.webAppListener.contextDestroyed(servletContextEvent);
        this.webAppListener = null;
        ServletContext servletContext = servletContextEvent.getServletContext();
        GroovyHelper groovyHelper = GroovyHelper.getCurrentInstance(servletContext);
        if (groovyHelper != null) {
            groovyHelper.setClassLoader();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "ConfigureListener.contextDestroyed({0})", servletContext.getServletContextName());
        }
        try {
            FactoryFinder.releaseFactories();
            if (this.webResourcePool != null) {
                this.webResourcePool.shutdown();
            }
        }
        finally {
            InitFacesContext initFacesContext = new InitFacesContext(servletContext);
            ApplicationAssociate.clearInstance(initFacesContext.getExternalContext());
            ApplicationAssociate.setCurrentInstance(null);
            ConfigManager.getInstance().destory(servletContext);
            initFacesContext.release();
            ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
            WebConfiguration.clear(servletContext);
        }
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.requestDestroyed(servletRequestEvent);
        }
    }

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.requestInitialized(servletRequestEvent);
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.sessionCreated(httpSessionEvent);
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.sessionDestroyed(httpSessionEvent);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent servletRequestAttributeEvent) {
    }

    public void attributeRemoved(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeRemoved(servletRequestAttributeEvent);
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeReplaced(servletRequestAttributeEvent);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeRemoved(httpSessionBindingEvent);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeReplaced(httpSessionBindingEvent);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeRemoved(servletContextAttributeEvent);
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (this.webAppListener != null) {
            this.webAppListener.attributeReplaced(servletContextAttributeEvent);
        }
    }

    private void initConfigMonitoring(ServletContext servletContext) {
        Collection collection = (Collection)servletContext.getAttribute("com.sun.faces.webresources");
        if (this.isDevModeEnabled() && collection != null && !collection.isEmpty()) {
            this.webResourcePool = new ScheduledThreadPoolExecutor(1);
            this.webResourcePool.scheduleAtFixedRate(new WebConfigResourceMonitor(servletContext, collection), 2000L, 2000L, TimeUnit.MILLISECONDS);
        }
        servletContext.removeAttribute("com.sun.faces.webresources");
    }

    private void initScripting() {
        GroovyHelper groovyHelper = GroovyHelperFactory.createHelper();
        if (groovyHelper != null) {
            groovyHelper.setClassLoader();
        }
    }

    private boolean isDevModeEnabled() {
        return this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DevelopmentMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(ServletContext servletContext) {
        Object object;
        Object object2;
        Object object3;
        GroovyHelper groovyHelper;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Reloading JSF configuration for context {0}", ConfigureListener.getServletContextIdentifier(servletContext));
        }
        if ((groovyHelper = GroovyHelper.getCurrentInstance()) != null) {
            groovyHelper.setClassLoader();
        }
        try {
            object3 = this.webAppListener.getActiveSessions();
            if (object3 != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (HttpSession)object2.next();
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "Invalidating Session {0}", object.getId());
                    }
                    object.invalidate();
                }
            }
            if ((object2 = ApplicationAssociate.getInstance(servletContext)) != null) {
                object = ((ApplicationAssociate)object2).getBeanManager();
                for (Map.Entry<String, BeanBuilder> entry : ((BeanManager)object).getRegisteredBeans().entrySet()) {
                    String string = entry.getKey();
                    BeanBuilder beanBuilder = entry.getValue();
                    if (beanBuilder.getScope() != ELUtils.Scope.APPLICATION) continue;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "Removing application scoped managed bean: {0}", string);
                    }
                    servletContext.removeAttribute(string);
                }
            }
            FactoryFinder.releaseFactories();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            object3 = new InitFacesContext(servletContext);
            ApplicationAssociate.clearInstance(object3.getExternalContext());
            ApplicationAssociate.setCurrentInstance(null);
            ConfigManager.getInstance().destory(servletContext);
            object3.release();
            ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
            WebConfiguration.clear(servletContext);
        }
        this.webAppListener = new WebappLifecycleListener(servletContext);
        object3 = new InitFacesContext(servletContext);
        ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
        try {
            object2 = ConfigManager.getInstance();
            ((ConfigManager)object2).initialize(servletContext);
            this.registerELResolverAndListenerWithJsp(servletContext, true);
            object = ApplicationAssociate.getInstance(servletContext);
            if (object != null) {
                ((ApplicationAssociate)object).setContextName(ConfigureListener.getServletContextIdentifier(servletContext));
            }
            RenderKitUtils.loadSunJsfJs(object3.getExternalContext());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            object3.release();
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Reload complete.", ConfigureListener.getServletContextIdentifier(servletContext));
        }
    }

    private static String getServletContextIdentifier(ServletContext servletContext) {
        if (servletContext.getMajorVersion() == 2 && servletContext.getMinorVersion() < 5) {
            return servletContext.getServletContextName();
        }
        return servletContext.getContextPath();
    }

    private static boolean isJspTwoOne(ServletContext servletContext) {
        try {
            Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (JspFactory.getDefaultFactory() == null) {
            return false;
        }
        try {
            JspFactory.class.getMethod("getJspApplicationContext", ServletContext.class);
        }
        catch (Exception exception) {
            return false;
        }
        try {
            JspFactory.getDefaultFactory().getJspApplicationContext(servletContext);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public void registerELResolverAndListenerWithJsp(ServletContext servletContext, boolean bl) {
        if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ExpressionFactory) || !ConfigureListener.isJspTwoOne(servletContext)) {
            if (!this.installExpressionFactory(servletContext, this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ExpressionFactory))) {
                throw new ConfigurationException(MessageUtils.getExceptionMessageString("com.sun.faces.INCORRECT_JSP_VERSION", WebConfiguration.WebContextInitParameter.ExpressionFactory.getDefaultValue(), WebConfiguration.WebContextInitParameter.ExpressionFactory.getQualifiedName()));
            }
        } else {
            JspApplicationContext jspApplicationContext;
            block8: {
                if (JspFactory.getDefaultFactory().getJspApplicationContext(servletContext) == null) {
                    return;
                }
                ChainTypeCompositeELResolver chainTypeCompositeELResolver = new ChainTypeCompositeELResolver(FacesCompositeELResolver.ELResolverChainType.JSP);
                ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(servletContext);
                if (applicationAssociate != null) {
                    applicationAssociate.setFacesELResolverForJsp(chainTypeCompositeELResolver);
                }
                jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(servletContext);
                if (applicationAssociate != null) {
                    applicationAssociate.setExpressionFactory(jspApplicationContext.getExpressionFactory());
                }
                try {
                    jspApplicationContext.addELResolver((ELResolver)chainTypeCompositeELResolver);
                }
                catch (IllegalStateException illegalStateException) {
                    if (Util.isUnitTestModeEnabled() || bl) break block8;
                    throw illegalStateException;
                }
            }
            ELContextListenerImpl eLContextListenerImpl = new ELContextListenerImpl();
            jspApplicationContext.addELContextListener((ELContextListener)eLContextListenerImpl);
        }
    }

    private boolean installExpressionFactory(ServletContext servletContext, String string) {
        if (string == null) {
            return false;
        }
        try {
            ExpressionFactory expressionFactory = (ExpressionFactory)Util.loadClass(string, this).newInstance();
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(servletContext);
            if (applicationAssociate != null) {
                applicationAssociate.setExpressionFactory(expressionFactory);
            }
            return true;
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(MessageFormat.format("Unable to instantiate ExpressionFactory ''{0}''", string));
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebConfigResourceMonitor
    implements Runnable {
        private List<Monitor> monitors;
        private ServletContext sc;

        public WebConfigResourceMonitor(ServletContext servletContext, Collection<URL> collection) {
            assert (collection != null);
            this.sc = servletContext;
            for (URL uRL : collection) {
                if (this.monitors == null) {
                    this.monitors = new ArrayList<Monitor>(collection.size());
                }
                this.monitors.add(new Monitor(uRL));
            }
        }

        @Override
        public void run() {
            assert (this.monitors != null);
            boolean bl = false;
            for (Monitor monitor : this.monitors) {
                if (!monitor.hasBeenModified() || bl) continue;
                bl = true;
            }
            if (bl) {
                ConfigureListener.this.reload(this.sc);
            }
        }

        private class Monitor {
            private URL url;
            private long timestamp = -1L;

            Monitor(URL uRL) {
                this.url = uRL;
                this.timestamp = this.getLastModified();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Monitoring {0} for modifications", uRL.toExternalForm());
                }
            }

            boolean hasBeenModified() {
                long l = this.getLastModified();
                if (this.timestamp < l) {
                    this.timestamp = l;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "{0} changed!", this.url.toExternalForm());
                    }
                    return true;
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getLastModified() {
                InputStream inputStream = null;
                try {
                    URLConnection uRLConnection = this.url.openConnection();
                    uRLConnection.connect();
                    inputStream = uRLConnection.getInputStream();
                    long l = uRLConnection.getLastModified();
                    return l;
                }
                catch (IOException iOException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "Unable to check JAR timestamp.", iOException);
                    }
                    long l = this.timestamp;
                    return l;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private static class WebXmlProcessor {
        private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
        private boolean facesServletPresent;

        WebXmlProcessor(ServletContext servletContext) {
            if (servletContext != null) {
                this.scanForFacesServlet(servletContext);
            }
        }

        boolean isFacesServletPresent() {
            return this.facesServletPresent;
        }

        private void scanForFacesServlet(ServletContext servletContext) {
            SAXParserFactory sAXParserFactory = this.getConfiguredFactory();
            try {
                SAXParser sAXParser = Util.newSAXParser(sAXParserFactory);
                sAXParser.parse(servletContext.getResourceAsStream(WEB_XML_PATH), (DefaultHandler)new WebXmlHandler());
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, MessageFormat.format("Unable to process deployment descriptor for context ''{0}''", ConfigureListener.getServletContextIdentifier(servletContext)));
                }
                this.facesServletPresent = true;
            }
        }

        private SAXParserFactory getConfiguredFactory() {
            SAXParserFactory sAXParserFactory = Util.createSAXParserFactory();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(true);
            return sAXParserFactory;
        }

        private class WebXmlHandler
        extends DefaultHandler {
            private static final String SERVLET_CLASS = "servlet-class";
            private static final String FACES_SERVLET = "javax.faces.webapp.FacesServlet";
            private boolean servletClassFound;
            private StringBuffer content;

            private WebXmlHandler() {
            }

            public InputSource resolveEntity(String string, String string2) throws SAXException {
                return new InputSource(new StringReader(""));
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (!WebXmlProcessor.this.facesServletPresent) {
                    if (SERVLET_CLASS.equals(string2)) {
                        this.servletClassFound = true;
                        this.content = new StringBuffer();
                    } else {
                        this.servletClassFound = false;
                    }
                }
            }

            public void characters(char[] cArray, int n, int n2) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent) {
                    this.content.append(cArray, n, n2);
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent && FACES_SERVLET.equals(this.content.toString().trim())) {
                    WebXmlProcessor.this.facesServletPresent = true;
                }
            }
        }
    }
}

