/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DbfFactory {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACES_1_2_XSD = "/com/sun/faces/web-facesconfig_1_2.xsd";
    private static final String FACES_1_1_XSD = "/com/sun/faces/web-facesconfig_1_1.xsd";
    private static Schema FACES_12_SCHEMA;
    private static Schema FACES_11_SCHEMA;
    public static final EntityResolver FACES_ENTITY_RESOLVER;
    public static final FacesErrorHandler FACES_ERROR_HANDLER;

    public static DocumentBuilderFactory getFactory() {
        DocumentBuilderFactory documentBuilderFactory = Util.createDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        return documentBuilderFactory;
    }

    private static void initSchema() {
        try {
            URL uRL = DbfFactory.class.getResource(FACES_1_2_XSD);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            InputStream inputStream = uRLConnection.getInputStream();
            SchemaFactory schemaFactory = Util.createSchemaFactory("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
            FACES_12_SCHEMA = schemaFactory.newSchema(new StreamSource(inputStream));
            uRL = DbfFactory.class.getResource(FACES_1_1_XSD);
            uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
            schemaFactory = Util.createSchemaFactory("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
            FACES_11_SCHEMA = schemaFactory.newSchema(new StreamSource(inputStream));
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
    }

    static /* synthetic */ Schema access$000() {
        return FACES_12_SCHEMA;
    }

    static /* synthetic */ Schema access$100() {
        return FACES_11_SCHEMA;
    }

    static {
        FACES_ENTITY_RESOLVER = new FacesEntityResolver();
        FACES_ERROR_HANDLER = new FacesErrorHandler();
        DbfFactory.initSchema();
    }

    private static final class Input
    implements LSInput {
        InputStream in;

        public Input(InputStream inputStream) {
            this.in = inputStream;
        }

        public Reader getCharacterStream() {
            return null;
        }

        public void setCharacterStream(Reader reader) {
        }

        public InputStream getByteStream() {
            return this.in;
        }

        public void setByteStream(InputStream inputStream) {
        }

        public String getStringData() {
            return null;
        }

        public void setStringData(String string) {
        }

        public String getSystemId() {
            return null;
        }

        public void setSystemId(String string) {
        }

        public String getPublicId() {
            return null;
        }

        public void setPublicId(String string) {
        }

        public String getBaseURI() {
            return null;
        }

        public void setBaseURI(String string) {
        }

        public String getEncoding() {
            return null;
        }

        public void setEncoding(String string) {
        }

        public boolean getCertifiedText() {
            return false;
        }

        public void setCertifiedText(boolean bl) {
        }
    }

    private static class FacesErrorHandler
    implements ErrorHandler {
        private FacesErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacesEntityResolver
    extends DefaultHandler
    implements LSResourceResolver {
        private static final String[][] DTD_SCHEMA_INFO = new String[][]{{"web-facesconfig_1_0.dtd", "/com/sun/faces/web-facesconfig_1_0.dtd"}, {"web-facesconfig_1_1.dtd", "/com/sun/faces/web-facesconfig_1_1.dtd"}, {"web-facesconfig_1_2.xsd", "/com/sun/faces/web-facesconfig_1_2.xsd"}, {"web-facesconfig_1_1.xsd", "/com/sun/faces/web-facesconfig_1_1.xsd"}, {"javaee_5.xsd", "/com/sun/faces/javaee_5.xsd"}, {"javaee_web_services_client_1_2.xsd", "/com/sun/faces/javaee_web_services_client_1_2.xsd"}, {"xml.xsd", "/com/sun/faces/xml.xsd"}, {"datatypes.dtd", "/com/sun/faces/datatypes.dtd"}, {"XMLSchema.dtd", "/com/sun/faces/XMLSchema.dtd"}};
        private HashMap<String, String> entities = new HashMap(6, 1.0f);

        public FacesEntityResolver() {
            for (String[] stringArray : DTD_SCHEMA_INFO) {
                URL uRL = this.getClass().getResource(stringArray[1]);
                if (uRL == null) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.config.cannot_resolve_entities", new Object[]{stringArray[1], stringArray[0]});
                    continue;
                }
                this.entities.put(stringArray[0], uRL.toString());
            }
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException {
            InputSource inputSource;
            if (string2 == null) {
                InputSource inputSource2;
                try {
                    inputSource2 = super.resolveEntity(string, null);
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
                return inputSource2;
            }
            String string3 = string2.substring(string2.lastIndexOf(47) + 1);
            String string4 = this.entities.get(string3);
            if (string4 == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unknown entity, deferring to superclass.");
                }
                try {
                    inputSource = super.resolveEntity(string, string2);
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
            }
            try {
                inputSource = new InputSource(new URL(string4).openStream());
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.config.cannot_create_inputsource", string4);
                }
                inputSource = null;
            }
            if (inputSource != null) {
                inputSource.setSystemId(string4);
                if (string != null) {
                    inputSource.setPublicId(string);
                }
            }
            return inputSource;
        }

        @Override
        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            try {
                InputSource inputSource = this.resolveEntity(string3, string4);
                if (inputSource != null) {
                    return new Input(inputSource.getByteStream());
                }
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
            return null;
        }

        public Map<String, String> getKnownEntities() {
            return Collections.unmodifiableMap(this.entities);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FacesSchema {
        FACES_12(DbfFactory.access$000()),
        FACES_11(DbfFactory.access$100());

        private Schema schema;

        private FacesSchema(Schema schema) {
            this.schema = schema;
        }

        public Schema getSchema() {
            return this.schema;
        }
    }
}

