/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.scripting.ActionListenerProxy;
import com.sun.faces.scripting.ELResolverProxy;
import com.sun.faces.scripting.NavigationHandlerProxy;
import com.sun.faces.scripting.PhaseListenerProxy;
import com.sun.faces.scripting.RendererProxy;
import com.sun.faces.scripting.ViewHandlerProxy;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELResolver;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigProcessor
implements ConfigProcessor {
    private ConfigProcessor nextProcessor;

    @Override
    public void setNext(ConfigProcessor configProcessor) {
        this.nextProcessor = configProcessor;
    }

    @Override
    public void invokeNext(ServletContext servletContext, Document[] documentArray) throws Exception {
        if (this.nextProcessor != null) {
            this.nextProcessor.process(servletContext, documentArray);
        }
    }

    protected Application getApplication() {
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        return applicationFactory.getApplication();
    }

    protected String getNodeText(Node node) {
        String string = null;
        if (node != null && (string = node.getTextContent()) != null) {
            string = string.trim();
        }
        return string != null && string.length() != 0 ? string : null;
    }

    protected Map<String, String> getTextMap(List<Node> list) {
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            HashMap<String, String> hashMap = new HashMap<String, String>(n, 1.0f);
            for (int i = 0; i < n; ++i) {
                Node node = list.get(i);
                String string = this.getNodeText(node);
                if (string == null) continue;
                if (node.hasAttributes()) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    String string2 = this.getNodeText(namedNodeMap.getNamedItem("lang"));
                    if (string2 == null) {
                        string2 = this.getNodeText(namedNodeMap.getNamedItem("xml:lang"));
                    }
                    if (string2 != null) {
                        hashMap.put(string2, string);
                        continue;
                    }
                    hashMap.put("DEFAULT", string);
                    continue;
                }
                hashMap.put("DEFAULT", string);
            }
            return hashMap;
        }
        return null;
    }

    protected Object createInstance(String string, Node node) {
        return this.createInstance(string, null, null, node);
    }

    protected Object createInstance(String string, Class clazz, Object object, Node node) {
        Object object2 = null;
        if (string != null) {
            try {
                Class<?> clazz2 = this.loadClass(string, object2, clazz);
                if (clazz2 != null) {
                    Object object3;
                    if (this.isDevModeEnabled() && (object3 = clazz2.getInterfaces()) != null) {
                        for (Class<?> clazz3 : object3) {
                            if (!"groovy.lang.GroovyObject".equals(clazz3.getName())) continue;
                            object2 = this.createScriptProxy(clazz, string, object);
                            break;
                        }
                    }
                    if (object2 == null && clazz != null && object != null && (object3 = ReflectionUtils.lookupConstructor(clazz2, clazz)) != null) {
                        object2 = ((Constructor)object3).newInstance(object);
                    }
                    if (clazz2 != null && object2 == null) {
                        object2 = clazz2.newInstance();
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to find class ''{0}''", string), node));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is missing a runtime dependency: {1}", string, noClassDefFoundError.toString()), node), noClassDefFoundError);
            }
            catch (ClassCastException classCastException) {
                throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is not an instance of ''{1}''", string, clazz), node));
            }
            catch (Exception exception) {
                throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to create a new instance of ''{0}'': {1}", string, exception.toString()), node), exception);
            }
        }
        return object2;
    }

    protected Class<?> loadClass(String string, Object object, Class<?> clazz) throws ClassNotFoundException {
        Class clazz2 = Util.loadClass(string, object);
        if (clazz != null && !clazz.isAssignableFrom(clazz2)) {
            throw new ClassCastException();
        }
        return clazz2;
    }

    private String buildMessage(String string, Node node) {
        return MessageFormat.format("\n  Source Document: {0}\n  Cause: {1}", node.getOwnerDocument().getDocumentURI(), string);
    }

    private Object createScriptProxy(Class<?> clazz, String string, Object object) {
        if (Renderer.class.equals(clazz)) {
            return new RendererProxy(string);
        }
        if (PhaseListener.class.equals(clazz)) {
            return new PhaseListenerProxy(string);
        }
        if (ViewHandler.class.equals(clazz)) {
            return new ViewHandlerProxy(string, (ViewHandler)object);
        }
        if (NavigationHandler.class.equals(clazz)) {
            return new NavigationHandlerProxy(string, (NavigationHandler)object);
        }
        if (ActionListener.class.equals(clazz)) {
            return new ActionListenerProxy(string, (ActionListener)object);
        }
        if (ELResolver.class.equals(clazz)) {
            return new ELResolverProxy(string);
        }
        return null;
    }

    private boolean isDevModeEnabled() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        return webConfiguration != null && webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DevelopmentMode);
    }
}

