/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.TypedCollections;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

public class RenderResponsePhase
extends Phase {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    public void execute(FacesContext facesContext) throws FacesException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RenderResponsePhase");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to render view " + facesContext.getViewRoot().getViewId());
        }
        try {
            Serializable serializable;
            Object object;
            if (LOGGER.isLoggable(Level.INFO) && (object = facesContext.getClientIdsWithMessages()).hasNext()) {
                serializable = new HashSet();
                while (object.hasNext()) {
                    serializable.add(object.next());
                }
                RequestStateManager.set(facesContext, "com.sun.faces.clientIdMessagesNotDisplayed", serializable);
            }
            facesContext.getApplication().getViewHandler().renderView(facesContext, facesContext.getViewRoot());
            if (LOGGER.isLoggable(Level.INFO) && RequestStateManager.containsKey(facesContext, "com.sun.faces.clientIdMessagesNotDisplayed") && !(object = TypedCollections.dynamicallyCastSet((Set)RequestStateManager.remove(facesContext, "com.sun.faces.clientIdMessagesNotDisplayed"), String.class)).isEmpty()) {
                serializable = new StringBuilder();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Iterator iterator2 = facesContext.getMessages(string);
                    while (iterator2.hasNext()) {
                        FacesMessage facesMessage = (FacesMessage)iterator2.next();
                        ((StringBuilder)serializable).append("\n");
                        ((StringBuilder)serializable).append("sourceId=").append(string);
                        ((StringBuilder)serializable).append("[severity=(").append(facesMessage.getSeverity());
                        ((StringBuilder)serializable).append("), summary=(").append(facesMessage.getSummary());
                        ((StringBuilder)serializable).append("), detail=(").append(facesMessage.getDetail()).append(")]");
                    }
                }
                LOGGER.log(Level.INFO, "jsf.non_displayed_message", ((StringBuilder)serializable).toString());
            }
        }
        catch (IOException iOException) {
            throw new FacesException(iOException.getMessage(), (Throwable)iOException);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "+=+=+=+=+=+= View structure printout for " + facesContext.getViewRoot().getViewId());
            DebugUtil.printTree((UIComponent)facesContext.getViewRoot(), LOGGER, Level.FINEST);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RenderResponsePhase");
        }
    }

    public PhaseId getId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

