/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.ResponseStateManagerImpl;
import com.sun.faces.renderkit.html_basic.HtmlResponseWriter;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

public class RenderKitImpl
extends RenderKit {
    private static final String[] SUPPORTED_CONTENT_TYPES_ARRAY = new String[]{"text/html", "application/xhtml+xml", "application/xml", "text/xml"};
    private static final String SUPPORTED_CONTENT_TYPES = "text/html,application/xhtml+xml,application/xml,text/xml";
    private ConcurrentHashMap<String, HashMap<Object, Renderer>> rendererFamilies = new ConcurrentHashMap();
    private ResponseStateManager responseStateManager = new ResponseStateManagerImpl();
    private WebConfiguration webConfig;

    public RenderKitImpl() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.webConfig = WebConfiguration.getInstance(facesContext.getExternalContext());
    }

    public void addRenderer(String string, String string2, Renderer renderer) {
        if (string == null) {
            String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "family");
            throw new NullPointerException(string3);
        }
        if (string2 == null) {
            String string4 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "rendererType");
            throw new NullPointerException(string4);
        }
        if (renderer == null) {
            String string5 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "renderer");
            throw new NullPointerException(string5);
        }
        HashMap<Object, Object> hashMap = this.rendererFamilies.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.rendererFamilies.put(string, hashMap);
        }
        hashMap.put(string2, renderer);
    }

    public Renderer getRenderer(String string, String string2) {
        if (string2 == null) {
            String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "rendererType");
            throw new NullPointerException(string3);
        }
        if (string == null) {
            String string4 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "family");
            throw new NullPointerException(string4);
        }
        assert (this.rendererFamilies != null);
        HashMap<Object, Renderer> hashMap = this.rendererFamilies.get(string);
        return hashMap != null ? hashMap.get(string2) : null;
    }

    public synchronized ResponseStateManager getResponseStateManager() {
        if (this.responseStateManager == null) {
            this.responseStateManager = new ResponseStateManagerImpl();
        }
        return this.responseStateManager;
    }

    public ResponseWriter createResponseWriter(Writer writer, String string, String string2) {
        String[] stringArray;
        if (writer == null) {
            return null;
        }
        String string3 = null;
        boolean bl = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != string) {
            string3 = this.findMatch(string, SUPPORTED_CONTENT_TYPES_ARRAY);
        }
        if (null == string && null != (string = facesContext.getExternalContext().getResponseContentType()) && null == (string3 = this.findMatch(string, SUPPORTED_CONTENT_TYPES_ARRAY))) {
            bl = true;
        }
        if (null == string || bl) {
            stringArray = (String[])facesContext.getExternalContext().getRequestHeaderValuesMap().get("Accept");
            if (stringArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(stringArray[0]);
                int n = stringArray.length;
                for (int i = 1; i < n; ++i) {
                    stringBuffer.append(',');
                    stringBuffer.append(stringArray[i]);
                }
                string = stringBuffer.toString();
            }
            if (null != string && null != (string = RenderKitUtils.determineContentType(string, SUPPORTED_CONTENT_TYPES, this.preferXhtml() ? "application/xhtml+xml" : null))) {
                string3 = this.findMatch(string, SUPPORTED_CONTENT_TYPES_ARRAY);
            }
        }
        if (string3 == null) {
            if (null == string) {
                string3 = this.getDefaultContentType();
            } else {
                stringArray = this.contentTypeSplit(string);
                for (String string4 : stringArray) {
                    if (!"*/*".equals(string4.trim())) continue;
                    string3 = this.getDefaultContentType();
                }
            }
        }
        if (null == string3) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.CONTENT_TYPE_ERROR", new Object[0]));
        }
        if (string2 == null) {
            string2 = "ISO-8859-1";
        }
        boolean bl2 = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableJSStyleHiding);
        boolean bl3 = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableScriptInAttributeValue);
        WebConfiguration.DisableUnicodeEscaping disableUnicodeEscaping = WebConfiguration.DisableUnicodeEscaping.getByValue(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.DisableUnicodeEscaping));
        return new HtmlResponseWriter(writer, string3, string2, bl2, bl3, disableUnicodeEscaping);
    }

    private boolean preferXhtml() {
        return this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.PreferXHTMLContentType);
    }

    private String getDefaultContentType() {
        return this.preferXhtml() ? "application/xhtml+xml" : "text/html";
    }

    private String[] contentTypeSplit(String string) {
        String[] stringArray = Util.split(string, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(";");
            if (-1 == n) continue;
            stringArray[i] = stringArray[i].substring(0, n);
        }
        return stringArray;
    }

    private String findMatch(String string, String[] stringArray) {
        String string2 = null;
        for (String string3 : this.contentTypeSplit(string)) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray[i].trim();
                if (!string3.contains(string4)) continue;
                if (string4.contains("text/html")) {
                    string2 = "text/html";
                    break;
                }
                if (!string4.contains("application/xhtml+xml") && !string4.contains("application/xml") && !string4.contains("text/xml")) break;
                string2 = "application/xhtml+xml";
                break;
            }
            if (null != string2) break;
        }
        return string2;
    }

    public ResponseStream createResponseStream(OutputStream outputStream) {
        final OutputStream outputStream2 = outputStream;
        return new ResponseStream(){

            public void write(int n) throws IOException {
                outputStream2.write(n);
            }

            public void write(byte[] byArray) throws IOException {
                outputStream2.write(byArray);
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                outputStream2.write(byArray, n, n2);
            }

            public void flush() throws IOException {
                outputStream2.flush();
            }

            public void close() throws IOException {
                outputStream2.close();
            }
        };
    }
}

