/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.LinkRenderer;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class CommandLinkRenderer
extends LinkRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.COMMANDLINK);
    private static final String SCRIPT_STATE = "com.sun.faces.scriptState";

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldDecode(uIComponent)) {
            return;
        }
        if (CommandLinkRenderer.wasClicked(facesContext, uIComponent)) {
            uIComponent.queueEvent((FacesEvent)new ActionEvent(uIComponent));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("This commandLink resulted in form submission  ActionEvent queued.");
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        boolean bl = Boolean.TRUE.equals(uIComponent.getAttributes().get("disabled"));
        String string = CommandLinkRenderer.getFormClientId(uIComponent, facesContext);
        if (string == null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Component {0} must be enclosed inside a form", uIComponent.getId());
        }
        if (bl || string == null) {
            this.renderAsDisabled(facesContext, uIComponent);
        } else {
            if (!CommandLinkRenderer.hasScriptBeenRendered(facesContext)) {
                RenderKitUtils.renderFormInitScript(facesContext.getResponseWriter(), facesContext);
                CommandLinkRenderer.setScriptAsRendered(facesContext);
            }
            this.renderAsActive(facesContext, uIComponent);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncodeChildren(uIComponent)) {
            return;
        }
        if (uIComponent.getChildCount() > 0) {
            for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                this.encodeRecursive(facesContext, uIComponent2);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        assert (responseWriter != null);
        String string = CommandLinkRenderer.getFormClientId(uIComponent, facesContext);
        if (string == null) {
            responseWriter.write(MessageUtils.getExceptionMessageString("com.sun.faces.COMMAND_LINK_NO_FORM_MESSAGE", new Object[0]));
            responseWriter.endElement("span");
            return;
        }
        if (Boolean.TRUE.equals(uIComponent.getAttributes().get("disabled"))) {
            responseWriter.endElement("span");
        } else {
            responseWriter.endElement("a");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected Object getValue(UIComponent uIComponent) {
        return ((UICommand)uIComponent).getValue();
    }

    protected String getOnClickScript(String string, String string2, String string3, HtmlBasicRenderer.Param[] paramArray) {
        return RenderKitUtils.getCommandLinkOnClickScript(string, string2, string3, paramArray);
    }

    protected void renderAsActive(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        boolean bl;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        assert (responseWriter != null);
        String string = CommandLinkRenderer.getFormClientId(uIComponent, facesContext);
        if (string == null) {
            return;
        }
        responseWriter.startElement("a", uIComponent);
        this.writeIdAttributeIfNecessary(facesContext, responseWriter, uIComponent);
        responseWriter.writeAttribute("href", (Object)"#", "href");
        RenderKitUtils.renderPassThruAttributes(responseWriter, uIComponent, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(responseWriter, uIComponent);
        String string2 = (String)uIComponent.getAttributes().get("onclick");
        StringBuffer stringBuffer = new StringBuffer(128);
        boolean bl2 = bl = string2 != null && !"".equals(string2);
        if (bl) {
            stringBuffer.append("var a=function(){");
            string2 = string2.trim();
            stringBuffer.append(string2);
            if (string2.charAt(string2.length() - 1) != ';') {
                stringBuffer.append(';');
            }
            stringBuffer.append("};var b=function(){");
        }
        HtmlBasicRenderer.Param[] paramArray = this.getParamList(uIComponent);
        String string3 = uIComponent.getClientId(facesContext);
        String string4 = (String)uIComponent.getAttributes().get("target");
        string4 = string4 != null ? string4.trim() : "";
        stringBuffer.append(this.getOnClickScript(string, string3, string4, paramArray));
        if (bl) {
            stringBuffer.append("};return (a()==false) ? false : b();");
        }
        responseWriter.writeAttribute("onclick", (Object)stringBuffer.toString(), "onclick");
        this.writeCommonLinkAttributes(responseWriter, uIComponent);
        this.writeValue(uIComponent, responseWriter);
        responseWriter.flush();
    }

    private static boolean hasScriptBeenRendered(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap().get(SCRIPT_STATE) != null;
    }

    private static void setScriptAsRendered(FacesContext facesContext) {
        facesContext.getExternalContext().getRequestMap().put(SCRIPT_STATE, Boolean.TRUE);
    }

    private static String getFormClientId(UIComponent uIComponent, FacesContext facesContext) {
        UIForm uIForm = CommandLinkRenderer.getMyForm(uIComponent);
        if (uIForm != null) {
            return uIForm.getClientId(facesContext);
        }
        return null;
    }

    private static UIForm getMyForm(UIComponent uIComponent) {
        UIComponent uIComponent2;
        for (uIComponent2 = uIComponent.getParent(); uIComponent2 != null && !(uIComponent2 instanceof UIForm); uIComponent2 = uIComponent2.getParent()) {
        }
        return (UIForm)uIComponent2;
    }

    private static boolean wasClicked(FacesContext facesContext, UIComponent uIComponent) {
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        return map.containsKey(uIComponent.getClientId(facesContext));
    }
}

