/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.scripting;

import com.sun.faces.scripting.GroovyHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import groovy.util.GroovyScriptEngine;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroovyHelperImpl
extends GroovyHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String SCRIPT_PATH = "/WEB-INF/groovy/";
    private MojarraGroovyClassLoader loader;

    GroovyHelperImpl() throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        URL uRL = facesContext.getExternalContext().getResource(SCRIPT_PATH);
        if (uRL != null) {
            final GroovyScriptEngine groovyScriptEngine = new GroovyScriptEngine(new URL[]{uRL}, Thread.currentThread().getContextClassLoader());
            this.loader = AccessController.doPrivileged(new PrivilegedAction<MojarraGroovyClassLoader>(){

                @Override
                public MojarraGroovyClassLoader run() {
                    return new MojarraGroovyClassLoader(groovyScriptEngine);
                }
            });
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Groovy support enabled.");
            }
        } else {
            throw new UnsupportedOperationException();
        }
        facesContext.getExternalContext().getApplicationMap().put("com.sun.faces.groovyhelper", this);
    }

    @Override
    public Class<?> loadScript(String string) {
        try {
            String string2 = string;
            if (string2.endsWith(".groovy")) {
                string2 = string2.substring(0, string2.indexOf(".groovy"));
            }
            return Util.loadClass(string2, this);
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }

    @Override
    public void setClassLoader() {
        Thread.currentThread().setContextClassLoader(this.loader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MojarraGroovyClassLoader
    extends URLClassLoader {
        private GroovyScriptEngine gse;

        public MojarraGroovyClassLoader(GroovyScriptEngine groovyScriptEngine) {
            super(new URL[0], (ClassLoader)groovyScriptEngine.getGroovyClassLoader());
            this.gse = groovyScriptEngine;
        }

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            Class clazz;
            if (string == null) {
                throw new NullPointerException();
            }
            try {
                clazz = this.gse.getGroovyClassLoader().getParent().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = this.gse.loadScriptByName(string);
                }
                catch (Exception exception) {
                    throw new ClassNotFoundException(string, exception);
                }
            }
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            return clazz;
        }
    }
}

