/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.RIConstants;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    public static final String RENDERKIT_LOGGER = ".renderkit";
    public static final String TAGLIB_LOGGER = ".taglib";
    public static final String APPLICATION_LOGGER = ".application";
    public static final String CONTEXT_LOGGER = ".context";
    public static final String CONFIG_LOGGER = ".config";
    public static final String LIFECYCLE_LOGGER = ".lifecycle";
    public static final String TIMING_LOGGER = ".timing";
    private static final String unitTestModeEnabled = "com.sun.faces.unitTestModeEnabled";
    private static final String coreTLVEnabled = "com.sun.faces.coreTLVEnabled";
    private static final String htmlTLVEnabled = "com.sun.faces.htmlTLVEnabled";
    private static final String patternCacheKey = "com.sun.faces.patternCache";
    private static ThreadLocal<Map<String, Object>> nonFacesContextApplicationMap;

    private Util() {
        throw new IllegalStateException();
    }

    private static void setNonFacesContextApplicationMap(Map<String, Object> map) {
        Util.lazilyInitializeNonFacesContextApplicationMap();
        if (null == map) {
            nonFacesContextApplicationMap.remove();
        } else {
            nonFacesContextApplicationMap.set(map);
        }
    }

    private static void lazilyInitializeNonFacesContextApplicationMap() {
        if (null == nonFacesContextApplicationMap) {
            nonFacesContextApplicationMap = new ThreadLocal<Map<String, Object>>(){

                @Override
                protected Map<String, Object> initialValue() {
                    return null;
                }
            };
        }
    }

    private static Map<String, Object> getNonFacesContextApplicationMap() {
        Util.lazilyInitializeNonFacesContextApplicationMap();
        return nonFacesContextApplicationMap.get();
    }

    private static Map<String, Object> getApplicationMap() {
        ExternalContext externalContext;
        HashMap<String, Object> hashMap = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext && null != (externalContext = facesContext.getExternalContext())) {
            hashMap = externalContext.getApplicationMap();
        }
        if (null == hashMap && null == (hashMap = Util.getNonFacesContextApplicationMap())) {
            hashMap = new HashMap<String, Object>();
            Util.setNonFacesContextApplicationMap(hashMap);
        }
        return hashMap;
    }

    private static Map<String, Pattern> getPatternCache() {
        Map<String, Object> map = Util.getApplicationMap();
        LRUMap lRUMap = (LRUMap)map.get(patternCacheKey);
        if (null == lRUMap) {
            lRUMap = new LRUMap(15);
            map.put(patternCacheKey, lRUMap);
        }
        return lRUMap;
    }

    private static Map<String, Pattern> getPatternCache(ServletContext servletContext) {
        LRUMap lRUMap = (LRUMap)servletContext.getAttribute(patternCacheKey);
        if (null == lRUMap) {
            lRUMap = new LRUMap(15);
            servletContext.setAttribute(patternCacheKey, lRUMap);
        }
        return lRUMap;
    }

    public static boolean isPortletRequest(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap().get("javax.portlet.faces.phase") != null;
    }

    public static Object getListenerInstance(ValueExpression valueExpression, ValueExpression valueExpression2) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object object = null;
        if (facesContext == null) {
            return null;
        }
        if (valueExpression2 != null) {
            object = valueExpression2.getValue(facesContext.getELContext());
        }
        if (object == null && valueExpression != null) {
            try {
                object = ReflectionUtils.newInstance((String)valueExpression.getValue(facesContext.getELContext()));
            }
            catch (Exception exception) {
                throw new AbortProcessingException(exception.getMessage(), (Throwable)exception);
            }
            if (valueExpression2 != null) {
                valueExpression2.setValue(facesContext.getELContext(), object);
            }
        }
        return object;
    }

    public static void setUnitTestModeEnabled(boolean bl) {
        Map<String, Object> map = Util.getApplicationMap();
        map.put(unitTestModeEnabled, bl);
    }

    public static boolean isUnitTestModeEnabled() {
        Boolean bl = false;
        Map<String, Object> map = Util.getApplicationMap();
        bl = (Boolean)map.get(unitTestModeEnabled);
        return null == bl ? false : bl;
    }

    public static void setCoreTLVActive(boolean bl) {
        Map<String, Object> map = Util.getApplicationMap();
        map.put(coreTLVEnabled, bl);
    }

    public static boolean isCoreTLVActive() {
        Boolean bl = true;
        Map<String, Object> map = Util.getApplicationMap();
        bl = (Boolean)map.get(coreTLVEnabled);
        return null == bl ? true : bl;
    }

    public static void setHtmlTLVActive(boolean bl) {
        Map<String, Object> map = Util.getApplicationMap();
        map.put(htmlTLVEnabled, bl);
    }

    public static boolean isHtmlTLVActive() {
        Boolean bl = true;
        Map<String, Object> map = Util.getApplicationMap();
        bl = (Boolean)map.get(htmlTLVEnabled);
        return null == bl ? true : bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransformerFactory createTransformerFactory() {
        TransformerFactory transformerFactory;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            transformerFactory = TransformerFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParserFactory createSAXParserFactory() {
        SAXParserFactory sAXParserFactory;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            sAXParserFactory = SAXParserFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return sAXParserFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return documentBuilderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaFactory createSchemaFactory(String string) {
        SchemaFactory schemaFactory;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            schemaFactory = SchemaFactory.newInstance(string);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return schemaFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilder newDocumentBuilder(DocumentBuilderFactory documentBuilderFactory) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParser newSAXParser(SAXParserFactory sAXParserFactory) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            return sAXParser;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Validator newValidator(DocumentBuilder documentBuilder) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            Validator validator = documentBuilder.getSchema().newValidator();
            return validator;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static Class loadClass(String string, Object object) throws ClassNotFoundException {
        ClassLoader classLoader = Util.getCurrentLoader(object);
        if (string.charAt(0) == '[') {
            return Class.forName(string, true, classLoader);
        }
        return classLoader.loadClass(string);
    }

    public static ClassLoader getCurrentLoader(Object object) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = object.getClass().getClassLoader();
        }
        return classLoader;
    }

    public static void notNull(String string, Object object) {
        if (object == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", string));
        }
    }

    public static Locale getLocaleFromContextOrSystem(FacesContext facesContext) {
        UIViewRoot uIViewRoot;
        Locale locale;
        Locale locale2 = locale = Locale.getDefault();
        if (null != facesContext && null != (uIViewRoot = facesContext.getViewRoot()) && null == (locale2 = uIViewRoot.getLocale())) {
            locale2 = locale;
        }
        return locale2;
    }

    public static Converter getConverterForClass(Class clazz, FacesContext facesContext) {
        if (clazz == null) {
            return null;
        }
        try {
            Application application = facesContext.getApplication();
            return application.createConverter(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Converter getConverterForIdentifer(String string, FacesContext facesContext) {
        if (string == null) {
            return null;
        }
        try {
            Application application = facesContext.getApplication();
            return application.createConverter(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static StateManager getStateManager(FacesContext facesContext) throws FacesException {
        return facesContext.getApplication().getStateManager();
    }

    public static ViewHandler getViewHandler(FacesContext facesContext) throws FacesException {
        Application application = facesContext.getApplication();
        assert (application != null);
        ViewHandler viewHandler = application.getViewHandler();
        assert (viewHandler != null);
        return viewHandler;
    }

    public static boolean componentIsDisabled(UIComponent uIComponent) {
        return Boolean.valueOf(String.valueOf(uIComponent.getAttributes().get("disabled")));
    }

    public static boolean componentIsDisabledOrReadonly(UIComponent uIComponent) {
        return Boolean.valueOf(String.valueOf(uIComponent.getAttributes().get("disabled"))) != false || Boolean.valueOf(String.valueOf(uIComponent.getAttributes().get("readonly"))) != false;
    }

    public static Locale getLocaleFromString(String string) throws IllegalArgumentException {
        if (null == string || string.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + string);
        }
        Locale locale = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        char[] cArray = new char[]{'-', '_'};
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        if (n3 >= 2 && (n = Util.indexOfSet(string, cArray, 0)) == -1) {
            if (n3 != 2) {
                throw new IllegalArgumentException("Illegal locale String: " + string);
            }
            string2 = string.toLowerCase();
        }
        if (n != -1) {
            string2 = string.substring(0, n);
            if (n3 >= 5 && (n2 = Util.indexOfSet(string, cArray, n + 1)) == -1) {
                if (n3 != 5) {
                    throw new IllegalArgumentException("Illegal locale String: " + string);
                }
                string3 = string.substring(n + 1);
            }
            if (n2 != -1) {
                string3 = string.substring(n + 1, n2);
                if (n3 >= 8) {
                    string4 = string.substring(n2 + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + string);
                }
            }
        }
        if (string4 != null && string3 != null && string2 != null) {
            locale = new Locale(string2, string3, string4);
        } else if (string2 != null && string3 != null) {
            locale = new Locale(string2, string3);
        } else if (string2 != null) {
            locale = new Locale(string2, "");
        }
        return locale;
    }

    public static int indexOfSet(String string, char[] cArray, int n) {
        int n2 = -1;
        int n3 = string.length();
        for (int i = n; i < n3; ++i) {
            int n4 = cArray.length;
            for (int j = 0; j < n4; ++j) {
                if (string.charAt(i) != cArray[j]) continue;
                n2 = i;
                break;
            }
            if (n2 != -1) break;
        }
        return n2;
    }

    public static void parameterNonNull(Object object) throws FacesException {
        if (null == object) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "param"));
        }
    }

    public static void parameterNonEmpty(String string) throws FacesException {
        if (null == string || 0 == string.length()) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EMPTY_PARAMETER", new Object[0]));
        }
    }

    public static String getStackTraceString(Throwable throwable) {
        if (null == throwable) {
            return "";
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append(stackTraceElementArray[i].toString()).append('\n');
        }
        return stringBuffer.toString();
    }

    public static String getContentTypeFromResponse(Object object) {
        String string = null;
        if (null != object) {
            try {
                Object object2;
                Method method = ReflectionUtils.lookupMethod(object.getClass(), "getContentType", RIConstants.EMPTY_CLASS_ARGS);
                if (null != method && null != (object2 = method.invoke(object, RIConstants.EMPTY_METH_ARGS))) {
                    string = object2.toString();
                }
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
        }
        return string;
    }

    public static boolean prefixViewTraversal(FacesContext facesContext, UIComponent uIComponent, TreeTraversalCallback treeTraversalCallback) throws FacesException {
        boolean bl = treeTraversalCallback.takeActionOnNode(facesContext, uIComponent);
        if (bl) {
            Iterator iterator = uIComponent.getFacetsAndChildren();
            while (iterator.hasNext() && bl) {
                bl = Util.prefixViewTraversal(facesContext, (UIComponent)iterator.next(), treeTraversalCallback);
            }
        }
        return bl;
    }

    public static FeatureDescriptor getFeatureDescriptor(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, Object object, Boolean bl4) {
        FeatureDescriptor featureDescriptor = new FeatureDescriptor();
        featureDescriptor.setName(string);
        featureDescriptor.setDisplayName(string2);
        featureDescriptor.setShortDescription(string3);
        featureDescriptor.setExpert(bl);
        featureDescriptor.setHidden(bl2);
        featureDescriptor.setPreferred(bl3);
        featureDescriptor.setValue("type", object);
        featureDescriptor.setValue("resolvableAtDesignTime", bl4);
        return featureDescriptor;
    }

    public static synchronized String[] split(String string, String string2) {
        Map<String, Pattern> map = Util.getPatternCache();
        Pattern pattern = map.get(string2);
        if (pattern == null) {
            pattern = Pattern.compile(string2);
            map.put(string2, pattern);
        }
        return pattern.split(string, 0);
    }

    public static synchronized String[] split(ServletContext servletContext, String string, String string2) {
        Map<String, Pattern> map = Util.getPatternCache(servletContext);
        Pattern pattern = map.get(string2);
        if (pattern == null) {
            pattern = Pattern.compile(string2);
            map.put(string2, pattern);
        }
        return pattern.split(string, 0);
    }

    public static String getFacesMapping(FacesContext facesContext) {
        String string;
        String string2;
        if (facesContext == null) {
            String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string3);
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Map<String, Object> map = RequestStateManager.getStateMap(facesContext);
        String string4 = (String)map.get("com.sun.faces.INVOCATION_PATH");
        if (string4 == null && (string4 = Util.getMappingForRequest(string2 = externalContext.getRequestServletPath(), string = externalContext.getRequestPathInfo())) == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.faces_servlet_mapping_cannot_be_determined_error", new Object[]{string2});
        }
        if (string4 != null) {
            map.put("com.sun.faces.INVOCATION_PATH", string4);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL pattern of the FacesServlet executing the current request " + string4);
        }
        return string4;
    }

    private static String getMappingForRequest(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "servletPath " + string);
            LOGGER.log(Level.FINE, "pathInfo " + string2);
        }
        if (string.length() == 0) {
            return "/*";
        }
        if (string2 != null) {
            return string;
        }
        if (string.indexOf(46) < 0) {
            return string;
        }
        return string.substring(string.lastIndexOf(46));
    }

    public static boolean isPrefixMapped(String string) {
        return string.charAt(0) == '/';
    }

    public static interface TreeTraversalCallback {
        public boolean takeActionOnNode(FacesContext var1, UIComponent var2) throws FacesException;
    }
}

