/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;

public class WebConfiguration {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern ALLOWABLE_BOOLEANS = Pattern.compile("true|false");
    private static final String WEB_CONFIG_KEY = "com.sun.faces.config.WebConfiguration";
    private Level loggingLevel = Level.FINE;
    private Map<BooleanWebContextInitParameter, Boolean> booleanContextParameters = new EnumMap<BooleanWebContextInitParameter, Boolean>(BooleanWebContextInitParameter.class);
    private Map<WebContextInitParameter, String> contextParameters = new EnumMap<WebContextInitParameter, String>(WebContextInitParameter.class);
    private Map<WebEnvironmentEntry, String> envEntries = new EnumMap<WebEnvironmentEntry, String>(WebEnvironmentEntry.class);
    private List<String> setParams = new ArrayList<String>();
    private ServletContext servletContext;

    private WebConfiguration(ServletContext servletContext) {
        this.servletContext = servletContext;
        String string = this.getServletContextName();
        this.initSetList(servletContext);
        this.processBooleanParameters(servletContext, string);
        this.processInitParameters(servletContext, string);
        if (this.canProcessJndiEntries()) {
            this.processJndiEntries(string);
        }
    }

    public static WebConfiguration getInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return WebConfiguration.getInstance(facesContext.getExternalContext());
    }

    public static WebConfiguration getInstance(ExternalContext externalContext) {
        WebConfiguration webConfiguration = (WebConfiguration)externalContext.getApplicationMap().get(WEB_CONFIG_KEY);
        if (webConfiguration == null) {
            return WebConfiguration.getInstance((ServletContext)externalContext.getContext());
        }
        return webConfiguration;
    }

    public static WebConfiguration getInstance(ServletContext servletContext) {
        WebConfiguration webConfiguration = (WebConfiguration)servletContext.getAttribute(WEB_CONFIG_KEY);
        if (webConfiguration == null) {
            webConfiguration = new WebConfiguration(servletContext);
            servletContext.setAttribute(WEB_CONFIG_KEY, (Object)webConfiguration);
        }
        return webConfiguration;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isOptionEnabled(BooleanWebContextInitParameter booleanWebContextInitParameter) {
        if (this.booleanContextParameters.get((Object)booleanWebContextInitParameter) != null) {
            return this.booleanContextParameters.get((Object)booleanWebContextInitParameter);
        }
        return booleanWebContextInitParameter.getDefaultValue();
    }

    public String getOptionValue(WebContextInitParameter webContextInitParameter) {
        return this.contextParameters.get((Object)webContextInitParameter);
    }

    public String getEnvironmentEntry(WebEnvironmentEntry webEnvironmentEntry) {
        return this.envEntries.get((Object)webEnvironmentEntry);
    }

    public boolean isSet(WebContextInitParameter webContextInitParameter) {
        return this.isSet(webContextInitParameter.getQualifiedName());
    }

    public boolean isSet(BooleanWebContextInitParameter booleanWebContextInitParameter) {
        return this.isSet(booleanWebContextInitParameter.getQualifiedName());
    }

    public String getServletContextName() {
        if (this.servletContext.getMajorVersion() == 2 && this.servletContext.getMinorVersion() <= 4) {
            return this.servletContext.getServletContextName();
        }
        return this.servletContext.getContextPath();
    }

    public void overrideContextInitParameter(BooleanWebContextInitParameter booleanWebContextInitParameter, boolean bl) {
        this.booleanContextParameters.put(booleanWebContextInitParameter, bl);
    }

    public void overrideContextInitParameter(WebContextInitParameter webContextInitParameter, String string) {
        this.contextParameters.put(webContextInitParameter, string);
    }

    public void overrideEnvEntry(WebEnvironmentEntry webEnvironmentEntry) {
    }

    static void clear(ServletContext servletContext) {
        servletContext.removeAttribute(WEB_CONFIG_KEY);
    }

    private boolean isValueValid(BooleanWebContextInitParameter booleanWebContextInitParameter, String string) {
        if (!ALLOWABLE_BOOLEANS.matcher(string).matches()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.config.webconfig.boolconfig.invalidvalue", new Object[]{string, booleanWebContextInitParameter.getQualifiedName(), "true|false"});
            }
            return false;
        }
        return true;
    }

    private void processBooleanParameters(ServletContext servletContext, String string) {
        for (BooleanWebContextInitParameter booleanWebContextInitParameter : BooleanWebContextInitParameter.values()) {
            boolean bl;
            String string2 = servletContext.getInitParameter(booleanWebContextInitParameter.getQualifiedName());
            if (string2 != null && string2.length() > 0 && booleanWebContextInitParameter.isDeprecated()) {
                BooleanWebContextInitParameter booleanWebContextInitParameter2 = booleanWebContextInitParameter.getAlternate();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    if (booleanWebContextInitParameter2 != null) {
                        LOGGER.log(Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{string, booleanWebContextInitParameter.getQualifiedName(), booleanWebContextInitParameter2.getQualifiedName()});
                    } else {
                        LOGGER.log(Level.WARNING, "jsf.config.webconfig.param.deprecated.no_replacement", new Object[]{string, booleanWebContextInitParameter.getQualifiedName()});
                    }
                }
                if (booleanWebContextInitParameter2 == null) continue;
                bl = this.isValueValid(booleanWebContextInitParameter, string2) ? Boolean.valueOf(string2).booleanValue() : booleanWebContextInitParameter.getDefaultValue();
                if (LOGGER.isLoggable(Level.INFO) && booleanWebContextInitParameter2 != null) {
                    LOGGER.log(Level.INFO, bl ? "jsf.config.webconfig.configinfo.reset.enabled" : "jsf.config.webconfig.configinfo.reset.disabled", new Object[]{string, booleanWebContextInitParameter2.getQualifiedName()});
                }
                this.booleanContextParameters.put(booleanWebContextInitParameter2, bl);
                continue;
            }
            if (booleanWebContextInitParameter.isDeprecated()) continue;
            bl = string2 == null ? booleanWebContextInitParameter.getDefaultValue() : (this.isValueValid(booleanWebContextInitParameter, string2) ? Boolean.valueOf(string2).booleanValue() : booleanWebContextInitParameter.getDefaultValue());
            if (BooleanWebContextInitParameter.DisplayConfiguration.equals((Object)booleanWebContextInitParameter) && bl) {
                this.loggingLevel = Level.INFO;
            }
            if (LOGGER.isLoggable(this.loggingLevel)) {
                LOGGER.log(this.loggingLevel, bl ? "jsf.config.webconfig.boolconfiginfo.enabled" : "jsf.config.webconfig.boolconfiginfo.disabled", new Object[]{string, booleanWebContextInitParameter.getQualifiedName()});
            }
            this.booleanContextParameters.put(booleanWebContextInitParameter, bl);
        }
    }

    private void initSetList(ServletContext servletContext) {
        Enumeration enumeration = servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (!string.startsWith("com.sun.faces")) continue;
            this.setParams.add(string);
        }
    }

    private boolean isSet(String string) {
        return this.setParams.contains(string);
    }

    private void processInitParameters(ServletContext servletContext, String string) {
        for (WebContextInitParameter webContextInitParameter : WebContextInitParameter.values()) {
            String string2 = servletContext.getInitParameter(webContextInitParameter.getQualifiedName());
            if (string2 != null && string2.length() > 0 && webContextInitParameter.isDeprecated()) {
                WebContextInitParameter webContextInitParameter2 = webContextInitParameter.getAlternate();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    if (webContextInitParameter2 != null) {
                        LOGGER.log(Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{string, webContextInitParameter.getQualifiedName(), webContextInitParameter2.getQualifiedName()});
                    } else {
                        LOGGER.log(Level.WARNING, "jsf.config.webconfig.param.deprecated.no_replacement", new Object[]{string, webContextInitParameter.getQualifiedName()});
                    }
                }
                if (webContextInitParameter2 == null) continue;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "jsf.config.webconfig.configinfo.reset", new Object[]{string, webContextInitParameter2.getQualifiedName(), string2});
                }
                this.contextParameters.put(webContextInitParameter2, string2);
                continue;
            }
            if (!(string2 != null && string2.length() != 0 || webContextInitParameter.isDeprecated())) {
                string2 = webContextInitParameter.getDefaultValue();
            }
            if (string2 == null || string2.length() == 0) continue;
            if (string2.length() > 0) {
                if (LOGGER.isLoggable(this.loggingLevel)) {
                    LOGGER.log(this.loggingLevel, "jsf.config.webconfig.configinfo", new Object[]{string, webContextInitParameter.getQualifiedName(), string2});
                }
                this.contextParameters.put(webContextInitParameter, string2);
                continue;
            }
            if (!LOGGER.isLoggable(this.loggingLevel)) continue;
            LOGGER.log(this.loggingLevel, "jsf.config.webconfig.option.notconfigured", new Object[]{string, webContextInitParameter.getQualifiedName()});
        }
    }

    private boolean canProcessJndiEntries() {
        try {
            Util.getCurrentLoader(this).loadClass("javax.naming.InitialContext");
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("javax.naming is unavailable.  JNDI entries related to Mojarra configuration will not be processed.");
            }
            return false;
        }
        return true;
    }

    private void processJndiEntries(String string) {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (initialContext != null) {
            for (WebEnvironmentEntry webEnvironmentEntry : WebEnvironmentEntry.values()) {
                String string2 = webEnvironmentEntry.getQualifiedName();
                try {
                    String string3 = (String)initialContext.lookup(string2);
                    if (string3 == null) continue;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        if (!webEnvironmentEntry.equals((Object)WebEnvironmentEntry.ClientStateSavingPassword)) {
                            if (LOGGER.isLoggable(this.loggingLevel)) {
                                LOGGER.log(this.loggingLevel, "jsf.config.webconfig.enventryinfo", new Object[]{string, string2, string3});
                            }
                        } else if (LOGGER.isLoggable(this.loggingLevel)) {
                            LOGGER.log(this.loggingLevel, "jsf.config.webconfig.enventry.clientencrypt", string);
                        }
                    }
                    this.envEntries.put(webEnvironmentEntry, string3);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisableUnicodeEscaping {
        True("true"),
        False("false"),
        Auto("auto");

        private final String value;

        private DisableUnicodeEscaping(String string2) {
            this.value = string2;
        }

        public static DisableUnicodeEscaping getByValue(String string) {
            for (DisableUnicodeEscaping disableUnicodeEscaping : DisableUnicodeEscaping.values()) {
                if (!disableUnicodeEscaping.value.equals(string)) continue;
                return disableUnicodeEscaping;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebEnvironmentEntry {
        ClientStateSavingPassword("ClientStateSavingPassword");

        private static final String JNDI_PREFIX = "java:comp/env/";
        private String qualifiedName;

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private WebEnvironmentEntry(String string2) {
            this.qualifiedName = "java:comp/env/com.sun.faces." + string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanWebContextInitParameter {
        DisplayConfiguration("com.sun.faces.displayConfiguration", false),
        ValidateFacesConfigFiles("com.sun.faces.validateXml", false),
        VerifyFacesConfigObjects("com.sun.faces.verifyObjects", false),
        ForceLoadFacesConfigFiles("com.sun.faces.forceLoadConfiguration", false),
        DisableArtifactVersioning("com.sun.faces.disableVersionTracking", false, true, null),
        EnableHtmlTagLibraryValidator("com.sun.faces.enableHtmlTagLibValidator", false),
        PreferXHTMLContentType("com.sun.faces.preferXHTML", false),
        PreferXHTMLContextTypeDeprecated("com.sun.faces.PreferXHTML", false, true, PreferXHTMLContentType),
        CompressViewState("com.sun.faces.compressViewState", true),
        CompressViewStateDeprecated("com.sun.faces.COMPRESS_STATE", true, true, CompressViewState),
        CompressJavaScript("com.sun.faces.compressJavaScript", true),
        ExternalizeJavaScript("com.sun.faces.externalizeJavaScript", false),
        SendPoweredByHeader("com.sun.faces.sendPoweredByHeader", true),
        EnableJSStyleHiding("com.sun.faces.enableJSStyleHiding", false),
        EnableScriptInAttributeValue("com.sun.faces.enableScriptsInAttributeValues", true),
        WriteStateAtFormEnd("com.sun.faces.writeStateAtFormEnd", true),
        EnableLazyBeanValidation("com.sun.faces.enableLazyBeanValidation", true),
        EnableLoadBundle11Compatibility("com.sun.faces.enabledLoadBundle11Compatibility", false),
        EnableRestoreView11Compatibility("com.sun.faces.enableRestoreView11Compatibility", false),
        SerializeServerState("com.sun.faces.serializeServerState", false),
        EnableViewStateIdRendering("com.sun.faces.enableViewStateIdRendering", true),
        RegisterConverterPropertyEditors("com.sun.faces.registerConverterPropertyEditors", false),
        DevelopmentMode("com.sun.faces.developmentMode", false),
        EnableThreading("com.sun.faces.enableThreading", true),
        EnableMultiThreadedStartup("com.sun.faces.enableMultiThreadedStartup", true, true, EnableThreading),
        AutoCompleteOffOnViewState("com.sun.faces.autoCompleteOffOnViewState", true),
        GenerateUniqueServerStateIds("com.sun.faces.generateUniqueServerStateIds", true);

        private BooleanWebContextInitParameter alternate;
        private String qualifiedName;
        private boolean defaultValue;
        private boolean deprecated;

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private BooleanWebContextInitParameter(String string2, boolean bl) {
            this(string2, bl, false, null);
        }

        private BooleanWebContextInitParameter(String string2, boolean bl, boolean bl2, BooleanWebContextInitParameter booleanWebContextInitParameter) {
            this.qualifiedName = string2;
            this.defaultValue = bl;
            this.deprecated = bl2;
            this.alternate = booleanWebContextInitParameter;
        }

        private BooleanWebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebContextInitParameter {
        ManagedBeanFactoryDecorator("com.sun.faces.managedBeanFactoryDecoratorClass", ""),
        StateSavingMethod("javax.faces.STATE_SAVING_METHOD", "server"),
        JspDefaultSuffix("javax.faces.DEFAULT_SUFFIX", ".jsp"),
        JavaxFacesConfigFiles("javax.faces.CONFIG_FILES", ""),
        AlternateLifecycleId("javax.faces.LIFECYCLE_ID", ""),
        NumberOfViews("com.sun.faces.numberOfViewsInSession", "15"),
        NumberOfViewsDeprecated("com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION", "15", true, NumberOfViews),
        NumberOfLogicalViews("com.sun.faces.numberOfLogicalViews", "15"),
        NumberOfLogicalViewsDeprecated("com.sun.faces.NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION", "15", true, NumberOfLogicalViews),
        InjectionProviderClass("com.sun.faces.injectionProvider", ""),
        SerializationProviderClass("com.sun.faces.serializationProvider", ""),
        ResponseBufferSize("com.sun.faces.responseBufferSize", "1024"),
        ClientStateWriteBufferSize("com.sun.faces.clientStateWriteBufferSize", "8192"),
        ExpressionFactory("com.sun.faces.expressionFactory", "com.sun.el.ExpressionFactoryImpl"),
        ClientStateTimeout("com.sun.faces.clientStateTimeout", ""),
        DisableUnicodeEscaping("com.sun.faces.disableUnicodeEscaping", "false"),
        DuplicateJARPattern("com.sun.faces.duplicateJARPattern", "");

        private String defaultValue;
        private String qualifiedName;
        private WebContextInitParameter alternate;
        private boolean deprecated;

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private WebContextInitParameter(String string2, String string3) {
            this(string2, string3, false, null);
        }

        private WebContextInitParameter(String string2, String string3, boolean bl, WebContextInitParameter webContextInitParameter) {
            this.qualifiedName = string2;
            this.defaultValue = string3;
            this.deprecated = bl;
            this.alternate = webContextInitParameter;
        }

        private WebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }
}

