/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FactoryConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACTORY = "factory";
    private static final String APPLICATION_FACTORY = "application-factory";
    private static final String FACES_CONTEXT_FACTORY = "faces-context-factory";
    private static final String LIFECYCLE_FACTORY = "lifecycle-factory";
    private static final String RENDER_KIT_FACTORY = "render-kit-factory";
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};

    public void process(ServletContext servletContext, Document[] documentArray) throws Exception {
        for (int i = 0; i < documentArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing factory elements for document: ''{0}''", documentArray[i].getDocumentURI()));
            }
            String string = documentArray[i].getDocumentElement().getNamespaceURI();
            NodeList nodeList = documentArray[i].getDocumentElement().getElementsByTagNameNS(string, FACTORY);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.processFactories(nodeList, string);
        }
        this.verifyFactoriesExist();
        this.invokeNext(servletContext, documentArray);
    }

    private void processFactories(NodeList nodeList, String string) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList2.item(j);
                if (APPLICATION_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.application.ApplicationFactory", this.getNodeText(node2));
                    continue;
                }
                if (LIFECYCLE_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.lifecycle.LifecycleFactory", this.getNodeText(node2));
                    continue;
                }
                if (FACES_CONTEXT_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.context.FacesContextFactory", this.getNodeText(node2));
                    continue;
                }
                if (!RENDER_KIT_FACTORY.equals(node2.getLocalName())) continue;
                FactoryConfigProcessor.setFactory("javax.faces.render.RenderKitFactory", this.getNodeText(node2));
            }
        }
    }

    private static void setFactory(String string, String string2) {
        if (string != null && string2 != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling FactoryFinder.setFactory({0}, {1})", string, string2));
            }
            FactoryFinder.setFactory((String)string, (String)string2);
        }
    }

    private void verifyFactoriesExist() {
        int n = FACTORY_NAMES.length;
        for (int i = 0; i < n; ++i) {
            try {
                FactoryFinder.getFactory((String)FACTORY_NAMES[i]);
                continue;
            }
            catch (Exception exception) {
                throw new ConfigurationException(MessageFormat.format("Factory ''{0}'' was not configured properly.", FACTORY_NAMES[i]), exception);
            }
        }
    }
}

