/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIInput;
import javax.faces.component._ComponentUtils;
import javax.faces.component._MessageUtils;
import javax.faces.component._PrimitiveArrayIterator;
import javax.faces.component._SelectItemsIterator;
import javax.faces.component._SelectItemsUtil;
import javax.faces.component._SharedRendererUtils;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISelectMany
extends UIInput {
    public static final String COMPONENT_TYPE = "javax.faces.SelectMany";
    public static final String COMPONENT_FAMILY = "javax.faces.SelectMany";
    public static final String INVALID_MESSAGE_ID = "javax.faces.component.UISelectMany.INVALID";

    public UISelectMany() {
        this.setRendererType("javax.faces.Listbox");
    }

    @Override
    public String getFamily() {
        return "javax.faces.SelectMany";
    }

    public Object[] getSelectedValues() {
        return (Object[])this.getValue();
    }

    public void setSelectedValues(Object[] selectedValues) {
        this.setValue(selectedValues);
    }

    @Override
    public ValueBinding getValueBinding(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("selectedValues")) {
            return super.getValueBinding("value");
        }
        return super.getValueBinding(name);
    }

    @Override
    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("selectedValues")) {
            super.setValueBinding("value", binding);
        } else {
            super.setValueBinding(name, binding);
        }
    }

    @Override
    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("selectedValues")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("selectedValues")) {
            super.setValueExpression("value", binding);
        } else {
            super.setValueExpression(name, binding);
        }
    }

    @Override
    protected boolean compareValues(Object previous, Object value) {
        if (previous == null) {
            return value != null;
        }
        if (value == null) {
            return true;
        }
        if (previous instanceof Object[] && value instanceof Object[]) {
            return this.compareObjectArrays((Object[])previous, (Object[])value);
        }
        if (previous instanceof Collection && value instanceof Collection) {
            return this.compareCollections((Collection)previous, (Collection)value);
        }
        if (previous.getClass().isArray() && value.getClass().isArray()) {
            return this.comparePrimitiveArrays(previous, value);
        }
        return true;
    }

    private boolean compareObjectArrays(Object[] previous, Object[] value) {
        int length = value.length;
        if (previous.length != length) {
            return true;
        }
        boolean[] scoreBoard = new boolean[length];
        for (int i = 0; i < length; ++i) {
            Object p = previous[i];
            boolean found = false;
            for (int j = 0; j < length; ++j) {
                if (scoreBoard[j]) continue;
                Object v = value[j];
                if ((p != null || v != null) && (p == null || v == null || !p.equals(v))) continue;
                scoreBoard[j] = true;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private boolean compareCollections(Collection<?> previous, Collection<?> value) {
        int length = value.size();
        if (previous.size() != length) {
            return true;
        }
        boolean[] scoreBoard = new boolean[length];
        for (Object p : previous) {
            boolean found = false;
            int j = 0;
            for (Object v : value) {
                if (!scoreBoard[j] && (p == null && v == null || p != null && v != null && p.equals(v))) {
                    scoreBoard[j] = true;
                    found = true;
                    break;
                }
                ++j;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private boolean comparePrimitiveArrays(Object previous, Object value) {
        int length = Array.getLength(value);
        if (Array.getLength(previous) != length) {
            return true;
        }
        boolean[] scoreBoard = new boolean[length];
        for (int i = 0; i < length; ++i) {
            Object p = Array.get(previous, i);
            boolean found = false;
            for (int j = 0; j < length; ++j) {
                if (scoreBoard[j]) continue;
                Object v = Array.get(value, j);
                if ((p != null || v != null) && (p == null || v == null || !p.equals(v))) continue;
                scoreBoard[j] = true;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void validateValue(FacesContext context, Object convertedValue) {
        Iterator<?> itemValues = this._createItemValuesIterator(convertedValue);
        if (itemValues == null) {
            _MessageUtils.addErrorMessage(context, this, INVALID_MESSAGE_ID, new Object[]{_MessageUtils.getLabel(context, this)});
            this.setValid(false);
            return;
        }
        boolean hasValues = itemValues.hasNext();
        if (this.isRequired() && !hasValues) {
            if (this.getRequiredMessage() != null) {
                String requiredMessage = this.getRequiredMessage();
                context.addMessage(this.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessage, requiredMessage));
            } else {
                _MessageUtils.addErrorMessage(context, this, "javax.faces.component.UIInput.REQUIRED", new Object[]{_MessageUtils.getLabel(context, this)});
            }
            this.setValid(false);
            return;
        }
        if (hasValues) {
            _ComponentUtils.callValidators(context, this, convertedValue);
        }
        if (this.isValid() && hasValues) {
            ArrayList items = new ArrayList();
            _SelectItemsIterator iter = new _SelectItemsIterator(this, context);
            while (iter.hasNext()) {
                items.add(iter.next());
            }
            Converter converter = this.getConverter();
            while (itemValues.hasNext()) {
                Object itemValue = itemValues.next();
                if (_SelectItemsUtil.matchValue(context, this, itemValue, items.iterator(), converter) && (!this.isRequired() || !_SelectItemsUtil.isNoSelectionOption(context, this, itemValue, items.iterator(), converter))) continue;
                _MessageUtils.addErrorMessage(context, this, INVALID_MESSAGE_ID, new Object[]{_MessageUtils.getLabel(context, this)});
                this.setValid(false);
                return;
            }
        }
    }

    @Override
    public void validate(FacesContext context) {
        super.validate(context);
    }

    @Override
    protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            return renderer.getConvertedValue(context, this, submittedValue);
        }
        if (submittedValue == null) {
            return null;
        }
        if (submittedValue instanceof String[]) {
            return _SharedRendererUtils.getConvertedUISelectManyValue(context, this, (String[])submittedValue);
        }
        return submittedValue;
    }

    private Iterator<?> _createItemValuesIterator(Object convertedValue) {
        if (convertedValue == null) {
            return Collections.emptyList().iterator();
        }
        Class<?> valueClass = convertedValue.getClass();
        if (valueClass.isArray()) {
            return new _PrimitiveArrayIterator(convertedValue);
        }
        if (convertedValue instanceof Object[]) {
            Object[] values = (Object[])convertedValue;
            return Arrays.asList(values).iterator();
        }
        if (convertedValue instanceof Collection) {
            Collection values = (Collection)convertedValue;
            return values.iterator();
        }
        return null;
    }
}

