/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component._ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class _ComponentFacetMap<V extends UIComponent>
implements Map<String, V>,
Serializable {
    private static final long serialVersionUID = -3456937594422167629L;
    private UIComponent _component;
    private Map<String, V> _map = new _ArrayMap<String, V>(0, 5);
    private Set<Map.Entry<String, V>> _entrySet = null;
    private Set<String> _keySet = null;
    private Collection<V> _valueCollection = null;

    _ComponentFacetMap(UIComponent component) {
        this._component = component;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public void clear() {
        UIComponent[] values = this._map.values().toArray(new UIComponent[this._map.size()]);
        this._map.clear();
        for (int i = 0; i < values.length; ++i) {
            values[i].setParent(null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkValue(value);
        return this._map.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        if (this._valueCollection == null) {
            this._valueCollection = new ComponentFacetValueCollection();
        }
        return this._valueCollection;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        for (Map.Entry<String, V> entry : t.entrySet()) {
            this.put(entry.getKey(), (V)((UIComponent)entry.getValue()));
        }
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new ComponentFacetEntrySet();
        }
        return this._entrySet;
    }

    @Override
    public Set<String> keySet() {
        if (this._keySet == null) {
            this._keySet = new ComponentFacetKeySet();
        }
        return this._keySet;
    }

    @Override
    public V get(Object key) {
        this.checkKey(key);
        return (V)((UIComponent)this._map.get(key));
    }

    @Override
    public V remove(Object key) {
        this.checkKey(key);
        UIComponent facet = (UIComponent)this._map.remove(key);
        if (facet != null) {
            facet.setParent(null);
        }
        return (V)facet;
    }

    @Override
    public V put(String key, V value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.setNewParent(key, (UIComponent)value);
        UIComponent previousValue = (UIComponent)this._map.put(key, value);
        if (previousValue != null) {
            previousValue.setParent(null);
        }
        return (V)previousValue;
    }

    private void setNewParent(String facetName, UIComponent facet) {
        UIComponent oldParent = facet.getParent();
        if (oldParent != null && !oldParent.getChildren().remove(facet) && oldParent.getFacetCount() > 0) {
            Iterator<Map.Entry<String, UIComponent>> it = oldParent.getFacets().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, UIComponent> entry = it.next();
                if (!entry.getValue().equals(facet)) continue;
                it.remove();
                break;
            }
        }
        facet.setParent(this._component);
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key is not a String");
        }
    }

    private void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (!(value instanceof UIComponent)) {
            throw new ClassCastException("value is not a UIComponent");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentFacetValueIterator
    implements Iterator<V> {
        private Iterator<Map.Entry<String, V>> _delegate;
        private V _currentEntryValue;

        public ComponentFacetValueIterator(Iterator<Map.Entry<String, V>> it) {
            this._delegate = it;
            this._currentEntryValue = null;
        }

        @Override
        public boolean hasNext() {
            return this._delegate.hasNext();
        }

        @Override
        public V next() {
            Map.Entry next = this._delegate.next();
            this._currentEntryValue = (UIComponent)next.getValue();
            return (UIComponent)next.getValue();
        }

        @Override
        public void remove() {
            this._delegate.remove();
            if (this._currentEntryValue != null) {
                ((UIComponent)this._currentEntryValue).setParent(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentFacetValueCollection
    extends AbstractCollection<V> {
        @Override
        public int size() {
            return _ComponentFacetMap.this._map.values().size();
        }

        @Override
        public boolean isEmpty() {
            return _ComponentFacetMap.this._map.values().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return _ComponentFacetMap.this._map.values().contains(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ComponentFacetValueIterator(_ComponentFacetMap.this._map.entrySet().iterator());
        }

        @Override
        public Object[] toArray() {
            return _ComponentFacetMap.this._map.values().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return _ComponentFacetMap.this._map.values().toArray(a);
        }

        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return _ComponentFacetMap.this._map.values().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            return _ComponentFacetMap.this._map.values().equals(obj);
        }

        @Override
        public int hashCode() {
            return _ComponentFacetMap.this._map.values().hashCode();
        }

        @Override
        public String toString() {
            return _ComponentFacetMap.this._map.values().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentFacetKeyIterator
    implements Iterator<String> {
        private Iterator<Map.Entry<String, V>> _delegate;
        private V _currentEntryValue;

        public ComponentFacetKeyIterator(Iterator<Map.Entry<String, V>> it) {
            this._delegate = it;
            this._currentEntryValue = null;
        }

        @Override
        public boolean hasNext() {
            return this._delegate.hasNext();
        }

        @Override
        public String next() {
            Map.Entry next = this._delegate.next();
            this._currentEntryValue = (UIComponent)next.getValue();
            return next.getKey();
        }

        @Override
        public void remove() {
            this._delegate.remove();
            if (this._currentEntryValue != null) {
                ((UIComponent)this._currentEntryValue).setParent(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentFacetKeySet
    extends AbstractSet<String> {
        @Override
        public int size() {
            return _ComponentFacetMap.this._map.keySet().size();
        }

        @Override
        public boolean isEmpty() {
            return _ComponentFacetMap.this._map.keySet().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return _ComponentFacetMap.this._map.keySet().contains(o);
        }

        @Override
        public Iterator<String> iterator() {
            return new ComponentFacetKeyIterator(_ComponentFacetMap.this._map.entrySet().iterator());
        }

        @Override
        public Object[] toArray() {
            return _ComponentFacetMap.this._map.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return _ComponentFacetMap.this._map.keySet().toArray(a);
        }

        @Override
        public boolean add(String o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            UIComponent previousValue = (UIComponent)_ComponentFacetMap.this._map.get(o);
            if (_ComponentFacetMap.this._map.keySet().remove(o)) {
                if (previousValue != null) {
                    previousValue.setParent(null);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return _ComponentFacetMap.this._map.keySet().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            return _ComponentFacetMap.this._map.keySet().equals(obj);
        }

        @Override
        public int hashCode() {
            return _ComponentFacetMap.this._map.keySet().hashCode();
        }

        @Override
        public String toString() {
            return _ComponentFacetMap.this._map.keySet().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentFacetEntry
    implements Map.Entry<String, V> {
        private Map.Entry<String, V> _entry;

        public ComponentFacetEntry(Map.Entry<String, V> entry) {
            this._entry = entry;
        }

        @Override
        public String getKey() {
            return this._entry.getKey();
        }

        @Override
        public V getValue() {
            return (UIComponent)this._entry.getValue();
        }

        @Override
        public V setValue(V value) {
            _ComponentFacetMap.this.setNewParent(this._entry.getKey(), value);
            UIComponent previousValue = (UIComponent)this._entry.setValue(value);
            if (previousValue != null) {
                previousValue.setParent(null);
            }
            return previousValue;
        }

        @Override
        public int hashCode() {
            return this._entry.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this._entry.equals(obj);
        }

        public String toString() {
            return this._entry.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentFacetEntryIterator
    implements Iterator<Map.Entry<String, V>> {
        private Iterator<Map.Entry<String, V>> _delegate;
        private V _currentEntryValue;

        public ComponentFacetEntryIterator(Iterator<Map.Entry<String, V>> it) {
            this._delegate = it;
            this._currentEntryValue = null;
        }

        @Override
        public boolean hasNext() {
            return this._delegate.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            Map.Entry next = this._delegate.next();
            this._currentEntryValue = (UIComponent)next.getValue();
            return new ComponentFacetEntry(next);
        }

        @Override
        public void remove() {
            this._delegate.remove();
            if (this._currentEntryValue != null) {
                ((UIComponent)this._currentEntryValue).setParent(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentFacetEntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        @Override
        public int size() {
            return _ComponentFacetMap.this._map.size();
        }

        @Override
        public boolean isEmpty() {
            return _ComponentFacetMap.this._map.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return _ComponentFacetMap.this._map.entrySet().contains(o);
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new ComponentFacetEntryIterator(_ComponentFacetMap.this._map.entrySet().iterator());
        }

        @Override
        public Object[] toArray() {
            return _ComponentFacetMap.this._map.entrySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return _ComponentFacetMap.this._map.entrySet().toArray(a);
        }

        @Override
        public boolean add(Map.Entry<String, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            if (_ComponentFacetMap.this._map.entrySet().remove(o)) {
                Object value;
                if (o instanceof Map.Entry && (value = ((Map.Entry)o).getValue()) != null && value instanceof UIComponent) {
                    ((UIComponent)value).setParent(null);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return _ComponentFacetMap.this._map.entrySet().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            return _ComponentFacetMap.this._map.entrySet().equals(obj);
        }

        @Override
        public int hashCode() {
            return _ComponentFacetMap.this._map.entrySet().hashCode();
        }

        @Override
        public String toString() {
            return _ComponentFacetMap.this._map.entrySet().toString();
        }
    }
}

