package org.wildfly.test.integration.replicationconfig;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.test.integration.common.HttpRequest;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * Verifies that a deployment with jboss-web.xml containing replication-config element can be deployed on the standard
 * profile.
 */
@RunWith(Arquillian.class)
@RunAsClient
public class ReplicationConfigTestCase {

    @ArquillianResource
    URL url;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive war = ShrinkWrap.create(WebArchive.class, "ReplicationConfigTestCase.war");
        war.addAsWebInfResource(ReplicationConfigTestCase.class.getPackage(), "jboss-web.xml", "jboss-web.xml");
        war.addAsWebInfResource(ReplicationConfigTestCase.class.getPackage(), "web.xml", "web.xml");
        war.addAsWebResource(new StringAsset("Hello"), "index.html");
        return war;
    }

    @Test
    public void testDeploymentSuccessful() throws IOException, ExecutionException, TimeoutException {
        // deployment would fail to deploy if broken
        String response = HttpRequest.get(url.toExternalForm(), 10, TimeUnit.SECONDS);
        Assert.assertTrue(response.contains("Hello"));
    }

}
